package cn.jasonone.jfx.factory;

import javafx.scene.Parent;
import javafx.scene.Scene;

import java.io.IOException;

/**
 * @author xujie
 * @version 1.0
 * @date 2021/12/22 8:48
 */
public interface SceneFactory {
    /**
     * 获取场景对象
     * @param id 场景ID
     * @return
     */
    Scene getScene(String id);

    /**
     * 获取指定控制器的场景对象
     * @param controllerClass
     * @return
     */
    Scene getScene(Class controllerClass);

    /**
     * 获取场景对象
     * @param id 场景ID
     * @param width  宽度
     * @param height 高度
     * @return
     */
    Scene getScene(String id,double width, double height);

    void destroy(Scene scene);
}
