package cn.jasonone.jfx.annotations;

import org.springframework.core.annotation.AliasFor;
import org.springframework.stereotype.Component;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author xujie
 * @version 1.0
 * @date 2021/12/21 11:53
 */
@Component
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface JFXController {
    @AliasFor(annotation = Component.class)
    String value() default "";

    /**
     * Fxml文件路径(基于fxml根目录),默认名称为控制器前缀,如: TestController => Test.fxml
     *
     * @return
     */
    String fxmlPath() default "";

    /**
     * 样式表
     *
     * @return
     */
    String[] stylesheet() default {};

    /**
     * 指定资源包名称
     *
     * @return
     */
    String resourceBundleName() default "";

}
