package cn.jasonone.jfx.annotations;

import cn.jasonone.jfx.factory.BeanFactory;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 数据模型绑定
 *
 * @author xujie
 * @version 1.0
 * @date 2021/12/22 16:22
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.FIELD})
public @interface BindModel {
    /**
     * 绑定的属性列表
     *
     * @return
     */
    BindProperty[] value() default {};

    Class<? extends BeanFactory> beanFactoryType() default BeanFactory.class;
}
