/*
 * Decompiled with CFR 0.152.
 */
package cn.jasonone.him.util;

import cn.jasonone.him.HimProperties;
import cn.jasonone.him.event.HimAuthorizationAfterEvent;
import cn.jasonone.him.event.HimAuthorizationBeforeEvent;
import cn.jasonone.him.event.HimEvent;
import cn.jasonone.him.event.HimExceptionEvent;
import cn.jasonone.him.event.HimMessageEvent;
import cn.jasonone.him.model.HimUserInfo;
import cn.jasonone.him.model.Message;
import cn.jasonone.him.service.HimService;
import cn.jasonone.him.util.HimUtil;
import com.corundumstudio.socketio.AckRequest;
import com.corundumstudio.socketio.AuthorizationListener;
import com.corundumstudio.socketio.Configuration;
import com.corundumstudio.socketio.HandshakeData;
import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.SocketIOServer;
import com.corundumstudio.socketio.Transport;
import com.corundumstudio.socketio.listener.ConnectListener;
import com.corundumstudio.socketio.listener.DataListener;
import com.corundumstudio.socketio.listener.DisconnectListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;

public class ServerUtil {
    private static final Logger log = LoggerFactory.getLogger(ServerUtil.class);
    private static SocketIOServer server;
    private static HimService himService;
    private static Map<String, SocketIOClient> clients;

    public static SocketIOServer createServer(HimProperties himProperties, HimService service, final ApplicationContext application) {
        if (himProperties == null) {
            himProperties = new HimProperties();
        }
        himService = service == null ? new HimService(){} : service;
        Configuration configuration = new Configuration();
        configuration.setPort(himProperties.getPort());
        configuration.setTransports(new Transport[]{Transport.POLLING, Transport.WEBSOCKET});
        configuration.setOrigin(himProperties.getOrigin());
        configuration.setHostname(himProperties.getHostname());
        configuration.setAuthorizationListener(new AuthorizationListener(){

            public boolean isAuthorized(HandshakeData data) {
                application.publishEvent((ApplicationEvent)new HimAuthorizationBeforeEvent((Object)himService, "AUTHORIZATION_AFTER_EVENT", "\u6743\u9650\u9274\u5b9a", data));
                boolean authorization = false;
                try {
                    authorization = himService.isAuthorization(data);
                    HashMap<String, Object> userData = new HashMap<String, Object>();
                    userData.put("result", authorization);
                    userData.put("data", data.getUrlParams());
                    application.publishEvent((ApplicationEvent)new HimAuthorizationAfterEvent((Object)himService, "AUTHORIZATION_AFTER_EVENT", "\u9274\u5b9a\u7ed3\u679c", (Map<String, Object>)userData));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    application.publishEvent((ApplicationEvent)new HimExceptionEvent((Object)himService, "EXCEPTION_EVENT", e.getMessage()));
                }
                return authorization;
            }
        });
        configuration.setPingTimeout(himProperties.getHeartbeatTimeout());
        configuration.setPingInterval(himProperties.getHeartbeatInterval());
        configuration.setOrigin(himProperties.getOrigin());
        SocketIOServer server = new SocketIOServer(configuration);
        log.info("\u6b63\u5728\u542f\u52a8Him\u670d\u52a1\u5668,\u670d\u52a1\u7aef\u53e3\u4e3a:{}", (Object)himProperties.getPort());
        server.addConnectListener(new ConnectListener(){

            public void onConnect(SocketIOClient client) {
                HimUserInfo user = null;
                try {
                    user = himService.connection(client);
                    if (user != null) {
                        user.setSessionId(client.getSessionId());
                        client.set("SESSION_USER", (Object)user);
                        if (clients.containsKey(user.getId())) {
                            ((SocketIOClient)clients.get(user.getId())).disconnect();
                        }
                        clients.put(user.getId(), client);
                    }
                    application.publishEvent(new HimEvent<HimUserInfo>(himService, "CONNECT_EVENT", "\u7528\u6237\u4e0a\u7ebf", user));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    application.publishEvent((ApplicationEvent)new HimExceptionEvent((Object)himService, "EXCEPTION_EVENT", e.getMessage()));
                }
            }
        });
        server.addDisconnectListener(new DisconnectListener(){

            public void onDisconnect(SocketIOClient client) {
                HimUserInfo user = null;
                try {
                    user = (HimUserInfo)client.get("SESSION_USER");
                    if (user != null) {
                        himService.disconnection(client, user);
                    }
                    application.publishEvent(new HimEvent<HimUserInfo>(himService, "DISCONNECT_EVENT", "\u7528\u6237\u79bb\u7ebf", user));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    application.publishEvent((ApplicationEvent)new HimExceptionEvent((Object)himService, "EXCEPTION_EVENT", e.getMessage()));
                }
            }
        });
        server.addEventListener("MESSAGE_FRIEND", Message.class, (DataListener)new DataListener<Message>(){

            public void onData(SocketIOClient client, Message data, AckRequest ackSender) throws Exception {
                log.debug("\u63a5\u6536\u6d88\u606f[{}]:{}", (Object)"MESSAGE_FRIEND", (Object)data);
                try {
                    himService.messageFriend(client, ackSender, data);
                    application.publishEvent((ApplicationEvent)new HimMessageEvent((Object)himService, "MESSAGE_FRIEND", "\u597d\u53cb\u6d88\u606f", data));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    application.publishEvent((ApplicationEvent)new HimExceptionEvent((Object)himService, "EXCEPTION_EVENT", e.getMessage()));
                }
            }
        });
        server.addEventListener("MESSAGE_GROUP", Message.class, (DataListener)new DataListener<Message>(){

            public void onData(SocketIOClient client, Message data, AckRequest ackSender) throws Exception {
                log.debug("\u63a5\u6536\u6d88\u606f[{}]:{}", (Object)"MESSAGE_GROUP", (Object)data);
                try {
                    himService.messageGroup(client, ackSender, data);
                    application.publishEvent((ApplicationEvent)new HimMessageEvent((Object)himService, "MESSAGE_GROUP", "\u7fa4\u6d88\u606f", data));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    application.publishEvent((ApplicationEvent)new HimExceptionEvent((Object)himService, "EXCEPTION_EVENT", e.getMessage()));
                }
            }
        });
        server.addEventListener("MESSAGE_SYSTEM", Message.class, (DataListener)new DataListener<Message>(){

            public void onData(SocketIOClient client, Message data, AckRequest ackSender) throws Exception {
                log.debug("\u63a5\u6536\u6d88\u606f[{}]:{}", (Object)"MESSAGE_SYSTEM", (Object)data);
                try {
                    himService.messageSystem(client, ackSender, data);
                    application.publishEvent((ApplicationEvent)new HimMessageEvent((Object)himService, "MESSAGE_SYSTEM", "\u7cfb\u7edf\u6d88\u606f", data));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    application.publishEvent((ApplicationEvent)new HimExceptionEvent((Object)himService, "EXCEPTION_EVENT", e.getMessage()));
                }
            }
        });
        HimUtil.setServer(server);
        return server;
    }

    static {
        clients = Collections.synchronizedMap(new HashMap());
    }
}

