/*
 * Decompiled with CFR 0.152.
 */
package cn.jasonone.him.util;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import cn.jasonone.him.HimConst;
import cn.jasonone.him.exception.NotFoundClientException;
import cn.jasonone.him.exception.NullException;
import cn.jasonone.him.model.HimUserInfo;
import cn.jasonone.him.model.R;
import com.corundumstudio.socketio.BroadcastOperations;
import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.SocketIOServer;
import java.util.Collection;
import java.util.Date;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HimUtil
implements HimConst {
    private static final Logger log = LoggerFactory.getLogger(HimUtil.class);
    private static SocketIOServer server;

    public static HimUserInfo getUserInfoById(String userId) {
        if (userId != null) {
            Collection clients = server.getAllClients();
            for (SocketIOClient client : clients) {
                HimUserInfo userInfo = HimUtil.getUserInfo(client);
                if (userInfo == null || !userId.equals(userInfo.getId())) continue;
                return userInfo;
            }
        }
        return null;
    }

    public static HimUserInfo getUserInfo(SocketIOClient client) {
        return (HimUserInfo)client.get("SESSION_USER");
    }

    public static void send(String groupId, String eventName, Object data) {
        if (StrUtil.isBlank((CharSequence)groupId)) {
            throw new NullException("\u7fa4ID\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        BroadcastOperations operations = server.getRoomOperations(groupId);
        if (operations == null) {
            throw new NotFoundClientException("\u7fa4\u672a\u627e\u5230:{}", new Object[]{groupId});
        }
        operations.sendEvent(eventName, new Object[]{data});
    }

    public static void send(UUID sessionID, String eventName, Object data) {
        if (sessionID == null) {
            throw new NullException("\u63a5\u6536\u65b9\u7528\u6237SessionID\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        SocketIOClient client = server.getClient(sessionID);
        if (client == null) {
            throw new NotFoundClientException("\u63a5\u6536\u65b9\u5ba2\u6237\u7aef\u5bf9\u8c61\u672a\u627e\u5230:{}", new Object[]{sessionID});
        }
        client.sendEvent(eventName, new Object[]{data});
    }

    public static void sendFriend(SocketIOClient client, HimUserInfo friend, String message) {
        HimUtil.sendFriend(HimUtil.getUserInfo(client), friend, message);
    }

    public static void sendFriend(HimUserInfo user, HimUserInfo friend, String message) {
        if (StrUtil.isBlank((CharSequence)friend.getId())) {
            throw new NullException("\u63a5\u6536\u65b9\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        if (StrUtil.isBlank((CharSequence)user.getId())) {
            throw new NullException("\u53d1\u9001\u65b9\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        R r = R.success().createChild("data");
        r.addItem("username", (Object)user.getUsername());
        r.addItem("avatar", (Object)user.getAvatar());
        r.addItem("id", (Object)user.getId());
        r.addItem("type", (Object)"friend");
        r.addItem("content", (Object)message);
        r.addItem("mine", (Object)user.getId().equals(friend.getId()));
        r.addItem("timestamp", (Object)new Date().getTime());
        log.debug("\u53d1\u9001\u6d88\u606f[{}]:{}", (Object)"MESSAGE_FRIEND", (Object)JSONUtil.toJsonStr((Object)r.getRoot()));
        HimUtil.send(friend.getSessionId(), "MESSAGE_FRIEND", (Object)r.getRoot());
    }

    public static void sendGroup(SocketIOClient client, String groupId, String message) {
        HimUserInfo userInfo = HimUtil.getUserInfo(client);
        HimUtil.sendGroup(userInfo, groupId, message);
    }

    public static void sendGroup(HimUserInfo user, String groupId, String message) {
        if (user == null) {
            throw new NullException("\u53d1\u9001\u65b9\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        if (user.getSessionId() == null) {
            throw new NullException("\u53d1\u9001\u65b9\u7528\u6237SessionID\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        if (StrUtil.isBlank((CharSequence)user.getId())) {
            throw new NullException("\u53d1\u9001\u65b9\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        R r = R.success().createChild("data");
        r.addItem("username", (Object)user.getUsername());
        r.addItem("avatar", (Object)user.getAvatar());
        r.addItem("id", (Object)groupId);
        r.addItem("type", (Object)"group");
        r.addItem("content", (Object)message);
        r.addItem("mine", (Object)user.getId());
        r.addItem("timestamp", (Object)new Date().getTime());
        log.debug("\u53d1\u9001\u6d88\u606f[{}]:{}", (Object)"MESSAGE_GROUP", (Object)JSONUtil.toJsonStr((Object)r.getRoot()));
        HimUtil.send(groupId, "MESSAGE_GROUP", (Object)r.getRoot());
    }

    public static void sendSystem(String message) {
        HimUtil.sendSystem(message, null);
    }

    public static void sendSystem(String message, Object data) {
        HimUtil.sendSystem(null, message, data);
    }

    public static void sendSystem(HimUserInfo user, String message, Object data) {
        R r = R.success();
        r.setMsg(message);
        r.addItem("data", data);
        if (user != null) {
            if (user.getSessionId() == null) {
                throw new NullException("\u63a5\u6536\u65b9\u7528\u6237SessionID\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
            }
            SocketIOClient client = server.getClient(user.getSessionId());
            if (client == null) {
                throw new NotFoundClientException("\u63a5\u6536\u65b9\u5ba2\u6237\u7aef\u5bf9\u8c61\u672a\u627e\u5230:{}", new Object[]{user.getSessionId()});
            }
            log.debug("\u53d1\u9001\u6d88\u606f[{}]\u7ed9[{}]:{}", new Object[]{"MESSAGE_SYSTEM", user.getSessionId(), JSONUtil.toJsonStr((Object)r)});
            client.sendEvent("MESSAGE_SYSTEM", new Object[]{r});
        } else {
            log.debug("\u53d1\u9001\u6d88\u606f[{}]:{}", (Object)"MESSAGE_SYSTEM", (Object)JSONUtil.toJsonStr((Object)r));
            BroadcastOperations operations = server.getBroadcastOperations();
            if (operations != null) {
                operations.sendEvent("MESSAGE_SYSTEM", new Object[]{JSONUtil.toJsonStr((Object)r)});
            }
        }
    }

    public static void addGroup(SocketIOClient client, String groupId) {
        log.debug("\u7528\u6237[{}]\u52a0\u5165\u7fa4\u804a:{}", (Object)client.getSessionId(), (Object)groupId);
        client.joinRoom(groupId);
    }

    public static void removeGroup(SocketIOClient client, String groupId) {
        log.debug("\u7528\u6237[{}]\u9000\u51fa\u7fa4\u804a:{}", (Object)client.getSessionId(), (Object)groupId);
        client.leaveRoom(groupId);
    }

    public static void setServer(SocketIOServer server) {
        HimUtil.server = server;
    }
}

