/*
 * Decompiled with CFR 0.152.
 */
package cn.jasonone.him.jmx;

import cn.hutool.json.JSONUtil;
import cn.jasonone.him.HimProperties;
import cn.jasonone.him.jmx.HimJmxProperties;
import cn.jasonone.him.jmx.HimMBean;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.rmi.registry.LocateRegistry;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HimJMXServer {
    private static final Logger log = LoggerFactory.getLogger(HimJMXServer.class);
    private static final String RMI_PASSWORD_FILE_ENVIRONMENT = "jmx.remote.x.password.file";
    private static final String RMI_ACCESS_FILE_ENVIRONMENT = "jmx.remote.x.access.file";
    private static final String RMI_PASSWORD_FILE = "him.password";
    private static final String RMI_ACCESS_FILE = "him.access";
    @Resource
    private HimProperties himProperties;
    @Resource
    private HimMBean himMBean;

    public void start() {
        HimJmxProperties jmxProperties = this.himProperties.getJmx();
        if (jmxProperties != null && jmxProperties.isEnable()) {
            try {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                ObjectName name = new ObjectName("himMBean:name=him");
                server.registerMBean(this.himMBean, name);
                log.debug("\u542f\u52a8JMX\u76d1\u63a7");
                log.trace("\u542f\u52a8JMX\u76d1\u63a7:{}", (Object)JSONUtil.toJsonStr((Object)jmxProperties));
                if (jmxProperties.isRmiEnable()) {
                    LocateRegistry.createRegistry(jmxProperties.getRmiPort());
                    String rmiUrl = "service:jmx:rmi:///jndi/rmi://" + jmxProperties.getRmiHost() + ":" + jmxProperties.getRmiPort() + "/himrmi";
                    JMXServiceURL serviceURL = new JMXServiceURL(rmiUrl);
                    HashMap<String, String> environment = new HashMap<String, String>();
                    if (jmxProperties.isAuthorizationEnable()) {
                        environment.put(RMI_ACCESS_FILE_ENVIRONMENT, RMI_ACCESS_FILE);
                        environment.put(RMI_PASSWORD_FILE_ENVIRONMENT, RMI_PASSWORD_FILE);
                        Path access = Paths.get(RMI_ACCESS_FILE, new String[0]);
                        Files.deleteIfExists(access);
                        Files.createFile(access, new FileAttribute[0]);
                        Files.write(access, (jmxProperties.getUserName() + " " + (Object)((Object)jmxProperties.getUserAuthorization())).getBytes(), new OpenOption[0]);
                        log.trace("RMI\u8d26\u53f7\u6587\u4ef6:{}", (Object)access.toAbsolutePath());
                        Path password = Paths.get(RMI_PASSWORD_FILE, new String[0]);
                        Files.deleteIfExists(password);
                        Files.createFile(password, new FileAttribute[0]);
                        Files.write(password, (jmxProperties.getUserName() + " " + jmxProperties.getPassword()).getBytes(), new OpenOption[0]);
                        log.trace("RMI\u5bc6\u7801\u6587\u4ef6:{}", (Object)password.toAbsolutePath());
                    }
                    JMXConnectorServer connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(serviceURL, environment, server);
                    connectorServer.start();
                    log.debug("\u5f00\u542fJMX RMI\u63a7\u5236\u53f0\u8bbf\u95ee:{} \u7528\u6237\u540d:{} \u5bc6\u7801:{} \u6743\u9650:{}", new Object[]{rmiUrl, jmxProperties.getUserName(), jmxProperties.getPassword(), jmxProperties.getUserAuthorization()});
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

