/*
 * Decompiled with CFR 0.152.
 */
package cn.jasonone.him.jmx;

import cn.hutool.json.JSONUtil;
import cn.jasonone.him.HimProperties;
import cn.jasonone.him.event.HimAuthorizationAfterEvent;
import cn.jasonone.him.event.HimAuthorizationBeforeEvent;
import cn.jasonone.him.event.HimEvent;
import cn.jasonone.him.event.HimExceptionEvent;
import cn.jasonone.him.event.HimMessageEvent;
import cn.jasonone.him.jmx.HimJmxProperties;
import cn.jasonone.him.jmx.HimMBean;
import cn.jasonone.him.model.HimUserInfo;
import cn.jasonone.him.model.Message;
import cn.jasonone.him.service.HimService;
import cn.jasonone.him.util.HimUtil;
import com.corundumstudio.socketio.HandshakeData;
import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.SocketIOServer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class Him
extends NotificationBroadcasterSupport
implements HimMBean {
    @Resource
    private HimService himService;
    @Resource
    private SocketIOServer server;
    private static final Map<String, Long> seqs = new HashMap<String, Long>(5);
    @Resource
    private HimProperties himProperties;

    private String userToString(HimUserInfo userInfo) {
        return "id:" + userInfo.getId() + ",username:" + userInfo.getUsername();
    }

    @Override
    public List<String> getClients() {
        ArrayList<String> list = new ArrayList<String>();
        Collection clients = this.server.getAllClients();
        for (SocketIOClient client : clients) {
            list.add(this.userToString(HimUtil.getUserInfo(client)));
        }
        return list;
    }

    @Override
    public List<String> getGroups() {
        ArrayList list = new ArrayList();
        this.server.getAllClients().stream().map(c -> c.getAllRooms()).forEach(r -> list.addAll(r));
        return list.stream().distinct().collect(Collectors.toList());
    }

    @Override
    public List<String> getGroups(String userId) {
        ArrayList<String> list = new ArrayList<String>();
        Collection clients = this.server.getAllClients();
        Stream<Set> stream = clients.stream().map(client -> HimUtil.getUserInfo(client)).filter(c -> c.getId().equals(userId)).map(c -> this.server.getClient(c.getSessionId()).getAllRooms());
        stream.forEach(g -> list.addAll((Collection<String>)g));
        return list;
    }

    @Override
    public List<String> getGroupMembers(String groupId) {
        return this.himService.findGroupById(groupId).getList().stream().map(u -> this.userToString((HimUserInfo)u)).collect(Collectors.toList());
    }

    @Override
    public List<String> getFriend(String userId) {
        return this.himService.findFriends(userId).stream().map(u -> JSONUtil.toJsonStr((Object)u)).collect(Collectors.toList());
    }

    @Async
    @EventListener
    public void listenerAuthorizationBefore(HimAuthorizationBeforeEvent event) {
        this.sendNotification(event, ((HandshakeData)event.getData()).getUrlParams());
    }

    @Async
    @EventListener
    public void listenerAuthorizationAfter(HimAuthorizationAfterEvent event) {
        this.sendNotification(event);
    }

    @Async
    @EventListener(condition="#event.type == 'CONNECT_EVENT'")
    public void listenerConnect(HimEvent<HimUserInfo> event) {
        HashMap<String, String> userData = new HashMap<String, String>();
        HimUserInfo userInfo = event.getData();
        if (userInfo != null) {
            userData.put("id", userInfo.getId());
            userData.put("username", userInfo.getUsername());
            userData.put("sessionId", userInfo.getSessionId().toString());
            userData.put("status", userInfo.getStatus().toString());
            this.sendNotification(event, userData);
        }
    }

    @Async
    @EventListener(condition="#event.type == 'DISCONNECT_EVENT'")
    public void listenerDisconnect(HimEvent<HimUserInfo> event) {
        HashMap<String, String> userData = new HashMap<String, String>();
        HimUserInfo userInfo = event.getData();
        if (userInfo != null) {
            userData.put("id", userInfo.getId());
            userData.put("username", userInfo.getUsername());
            userData.put("sessionId", userInfo.getSessionId().toString());
            userData.put("status", userInfo.getStatus().toString());
        }
        this.sendNotification(event, userData);
    }

    @Async
    @EventListener
    public void listenerMessage(HimMessageEvent event) {
        HashMap<String, String> userData = new HashMap<String, String>();
        if (event.getData() != null) {
            userData.put("id", ((Message)event.getData()).getId());
            userData.put("message", ((Message)event.getData()).getMessage());
        }
        this.sendNotification(event, userData);
    }

    @Async
    @EventListener
    public void listenerException(HimExceptionEvent event) {
        this.sendNotification(event);
    }

    public void sendNotification(HimEvent<?> event) {
        this.sendNotification(event.getType(), event.getSource(), event.getContent(), event.getData());
    }

    public void sendNotification(HimEvent<?> event, Object userData) {
        this.sendNotification(event.getType(), event.getSource(), event.getContent(), userData);
    }

    public void sendNotification(HimEvent<?> event, String content, Object userData) {
        this.sendNotification(event.getType(), event.getSource(), content, userData);
    }

    public void sendNotification(String type, Object source, String content, Object userData) {
        HimJmxProperties jmxProperties = this.himProperties.getJmx();
        if (jmxProperties == null || !jmxProperties.isNotificationEnable()) {
            return;
        }
        long seq = 1L;
        if (seqs.containsKey(type)) {
            seq = seqs.get(type) + 1L;
        }
        seqs.put(type, seq);
        Notification n = new Notification(type, source.getClass().getName(), seq, System.currentTimeMillis(), content);
        n.setUserData(userData);
        this.sendNotification(n);
    }
}

