/*
 * Decompiled with CFR 0.152.
 */
package cn.jasonone.him.controller;

import cn.jasonone.him.model.HimGroup;
import cn.jasonone.him.model.HimUserInfo;
import cn.jasonone.him.model.R;
import cn.jasonone.him.service.HimService;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/him"})
public class HimController {
    @Resource
    private HimService himService;

    @GetMapping(value={"/list"})
    public R list(String userId) {
        List groups;
        R r = R.success().createChild("data");
        HimUserInfo mine = this.himService.findMine(userId);
        if (mine == null) {
            return R.error((int)404, (String)"\u7528\u6237\u4e0d\u5b58\u5728");
        }
        r.addItem("mine", (Object)mine);
        List list = this.himService.findFriends(userId);
        if (list != null) {
            r.addItem("friend", list.stream().filter(f -> f != null).collect(Collectors.toList()));
        }
        if ((groups = this.himService.findGroups(userId)) != null) {
            r.addItem("group", groups.stream().filter(g -> g != null).collect(Collectors.toList()));
        }
        return r.getRoot();
    }

    @GetMapping(value={"/members"})
    public R members(String groupId) {
        R r = R.success().createChild("data");
        HimGroup group = this.himService.findGroupById(groupId);
        r.addItem("owner", (Object)group.getOwner());
        r.addItem("list", (Object)group.getList());
        return r.getRoot();
    }

    @PostMapping(value={"/uploadImage"})
    public R uploadImage(@RequestParam(value="file") MultipartFile file) {
        R r = R.success().setMsg("").createChild("data");
        try {
            r.addItem("src", (Object)this.himService.uploadImage(file));
            return r.getRoot();
        }
        catch (Exception e) {
            e.printStackTrace();
            return R.error((int)500, (String)"\u56fe\u7247\u4e0a\u4f20\u5931\u8d25");
        }
    }

    @PostMapping(value={"/uploadFile"})
    public R uploadFile(@RequestParam(value="file") MultipartFile file) {
        R r = R.success().setMsg("").createChild("data");
        try {
            r.addItem("src", (Object)this.himService.uploadFile(file));
            return r.getRoot();
        }
        catch (Exception e) {
            e.printStackTrace();
            return R.error((int)500, (String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
        }
    }
}

