/*
 * Decompiled with CFR 0.152.
 */
package cn.jasonone.him;

import cn.jasonone.him.HimProperties;
import cn.jasonone.him.jmx.HimJMXServer;
import cn.jasonone.him.service.HimService;
import cn.jasonone.him.util.ServerUtil;
import com.corundumstudio.socketio.SocketIOServer;
import com.corundumstudio.socketio.annotation.SpringAnnotationScanner;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;

@Configuration
@ComponentScan(value={"cn.jasonone.him"})
public class HimAutoConfig {
    private static final Logger log = LoggerFactory.getLogger(HimAutoConfig.class);
    @Resource
    private SocketIOServer server;
    @Resource
    private HimProperties himProperties;
    @Resource
    private HimJMXServer jmxServer;

    @EventListener
    public void closed(ContextClosedEvent e) {
        log.info("\u6b63\u5728\u505c\u6b62\u670d\u52a1,\u505c\u6b62\u7aef\u53e3\u4e3a:{}", (Object)this.himProperties.getPort());
        this.server.stop();
    }

    @Bean
    public SocketIOServer socketIOServer(HimService himService, HimProperties himProperties, ApplicationContext applicationContext) {
        SocketIOServer server = ServerUtil.createServer(himProperties, himService, applicationContext);
        server.start();
        return server;
    }

    @EventListener
    public void init(ContextRefreshedEvent e) {
        this.jmxServer.start();
    }

    @Bean
    public SpringAnnotationScanner springAnnotationScanner(SocketIOServer server) {
        return new SpringAnnotationScanner(server);
    }

    @Bean
    @ConditionalOnMissingBean(value={HimService.class})
    public HimService himService() {
        log.warn("\u672a\u627e\u5230\u81ea\u5b9a\u4e49HimService\u7684\u5b9e\u73b0\u7c7b,\u5c06\u4f7f\u7528\u9ed8\u8ba4\u5b9e\u73b0");
        return new HimService(){};
    }
}

