package cn.jasonone.him.jmx;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import lombok.Data;

@Data
@Configuration
@ConfigurationProperties("him.jmx")
public class HimJmxProperties {
	/**
	 * 是否开启JMX:默认 false
	 */
	private boolean enable;
	/**
	 * RMI远程访问端口
	 */
	private int rmiPort = 8090;
	/**
	 * RMI地址
	 */
	private String rmiHost = "localhost";
	/**
	 * 是否开启通知: 默认 false
	 */
	private boolean notificationEnable;
	/**
	 * 是否开启RMI远程监控: 默认 false
	 */
	private boolean rmiEnable;
	/**
	 * 是否开启权限鉴定: 默认 false
	 */
	private boolean authorizationEnable;
	/**
	 * 用户名:默认 him
	 */
	private String userName = "him";
	/**
	 * 密码: 默认 him123
	 */
	private String password = "him123";
	/**
	 * 用户权限: 默认 readonly(只读)
	 */
	private RMIAuth userAuthorization=RMIAuth.readonly;

}
