package cn.jasonone.him.event;

import org.springframework.context.ApplicationEvent;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * Him事件对象
 * 
 * @author Jason
 *
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class HimEvent<T> extends ApplicationEvent {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	/**
	 * 事件类型
	 */
	private String type;
	/**
	 * 事件内容
	 */
	private String content;
	/**
	 * 数据对象
	 */
	private T data;

	/**
	 * 创建事件对象
	 * 
	 * @param source 触发源
	 */
	public HimEvent(Object source) {
		super(source);
	}

	/**
	 * 创建事件对象
	 * 
	 * @param source 触发源
	 * @param type   事件类型
	 * @param data   数据
	 */
	public HimEvent(Object source, String type, T data) {
		super(source);
		this.type = type;
		this.data = data;
	}

	/**
	 * 创建事件对象
	 * 
	 * @param source  触发源
	 * @param type    事件类型
	 * @param content 事件内容
	 */
	public HimEvent(Object source, String type, String content) {
		super(source);
		this.type = type;
		this.content = content;
	}

	/**
	 * 创建事件对象
	 * 
	 * @param source  触发源
	 * @param type    事件类型
	 * @param content 事件内容
	 * @param data    数据
	 */
	public HimEvent(Object source, String type, String content, T data) {
		super(source);
		this.type = type;
		this.content = content;
		this.data = data;
	}

}
