/*
 * Decompiled with CFR 0.152.
 */
package cn.jasonone.him.util;

import cn.jasonone.him.HimProperties;
import cn.jasonone.him.model.HimUserInfo;
import cn.jasonone.him.model.Message;
import cn.jasonone.him.service.HimService;
import com.corundumstudio.socketio.AckRequest;
import com.corundumstudio.socketio.AuthorizationListener;
import com.corundumstudio.socketio.Configuration;
import com.corundumstudio.socketio.HandshakeData;
import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.SocketIOServer;
import com.corundumstudio.socketio.Transport;
import com.corundumstudio.socketio.listener.ConnectListener;
import com.corundumstudio.socketio.listener.DataListener;
import com.corundumstudio.socketio.listener.DisconnectListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerUtil {
    private static final Logger log = LoggerFactory.getLogger(ServerUtil.class);
    private static SocketIOServer server;
    private static HimService himService;

    public static SocketIOServer createServer(HimProperties himProperties, HimService service) {
        if (himProperties == null) {
            himProperties = new HimProperties();
        }
        himService = service == null ? new HimService(){} : service;
        Configuration configuration = new Configuration();
        configuration.setPort(himProperties.getPort());
        configuration.setTransports(new Transport[]{Transport.POLLING, Transport.WEBSOCKET});
        configuration.setOrigin(himProperties.getOrigin());
        configuration.setHostname(himProperties.getHostname());
        configuration.setAuthorizationListener(new AuthorizationListener(){

            public boolean isAuthorized(HandshakeData data) {
                return himService.isAuthorization(data);
            }
        });
        configuration.setPingTimeout(himProperties.getHeartbeatTimeout());
        configuration.setPingInterval(himProperties.getHeartbeatInterval());
        configuration.setOrigin(himProperties.getOrigin());
        SocketIOServer server = new SocketIOServer(configuration);
        log.info("\u6b63\u5728\u542f\u52a8Him\u670d\u52a1\u5668,\u670d\u52a1\u7aef\u53e3\u4e3a:{}", (Object)himProperties.getPort());
        server.addConnectListener(new ConnectListener(){

            public void onConnect(SocketIOClient client) {
                HimUserInfo user = himService.connection(client);
                if (user != null) {
                    user.setSessionId(client.getSessionId());
                    client.set("SESSION_USER", (Object)user);
                }
            }
        });
        server.addDisconnectListener(new DisconnectListener(){

            public void onDisconnect(SocketIOClient client) {
                HimUserInfo user = (HimUserInfo)client.get("SESSION_USER");
                if (user != null) {
                    himService.disconnection(client, user);
                }
            }
        });
        server.addEventListener("MESSAGE_FRIEND", Message.class, (DataListener)new DataListener<Message>(){

            public void onData(SocketIOClient client, Message data, AckRequest ackSender) throws Exception {
                log.debug("\u63a5\u6536\u6d88\u606f[{}]:{}", (Object)"MESSAGE_FRIEND", (Object)data);
                himService.messageFriend(client, ackSender, data);
            }
        });
        server.addEventListener("MESSAGE_GROUP", Message.class, (DataListener)new DataListener<Message>(){

            public void onData(SocketIOClient client, Message data, AckRequest ackSender) throws Exception {
                log.debug("\u63a5\u6536\u6d88\u606f[{}]:{}", (Object)"MESSAGE_GROUP", (Object)data);
                himService.messageGroup(client, ackSender, data);
            }
        });
        server.addEventListener("MESSAGE_SYSTEM", Message.class, (DataListener)new DataListener<Message>(){

            public void onData(SocketIOClient client, Message data, AckRequest ackSender) throws Exception {
                log.debug("\u63a5\u6536\u6d88\u606f[{}]:{}", (Object)"MESSAGE_SYSTEM", (Object)data);
                himService.messageSystem(client, ackSender, data);
            }
        });
        return server;
    }
}

