/*
 * Decompiled with CFR 0.152.
 */
package cn.jasonone.him.jmx;

import cn.jasonone.him.jmx.HimMBean;
import cn.jasonone.him.model.HimFriend;
import cn.jasonone.him.model.HimUserInfo;
import cn.jasonone.him.service.HimService;
import cn.jasonone.him.util.HimUtil;
import com.corundumstudio.socketio.SocketIOServer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class Him
implements HimMBean {
    @Resource
    private HimService himService;
    @Resource
    private SocketIOServer server;

    @Override
    public List<HimUserInfo> getClients() {
        Collection clients = this.server.getAllClients();
        return clients.stream().map(socket -> HimUtil.getUserInfo(socket)).collect(Collectors.toList());
    }

    @Override
    public List<String> getGroups() {
        ArrayList list = new ArrayList();
        this.server.getAllClients().stream().map(c -> c.getAllRooms()).forEach(r -> list.addAll(r));
        return list.stream().distinct().collect(Collectors.toList());
    }

    @Override
    public List<String> getGroups(String userId) {
        ArrayList<String> list = new ArrayList<String>();
        Stream<Set> stream = this.getClients().stream().filter(c -> c.getId().equals(userId)).map(c -> this.server.getClient(c.getSessionId()).getAllRooms());
        stream.forEach(g -> list.addAll((Collection<String>)g));
        return list;
    }

    @Override
    public List<HimUserInfo> getGroupMembers(String groupId) {
        return this.himService.findGroupById(groupId).getList();
    }

    @Override
    public List<HimFriend> getFriend(String userId) {
        return this.himService.findFriends(userId);
    }
}

