package cn.jasonone.him.jmx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import javax.annotation.Resource;

import org.springframework.stereotype.Component;

import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.SocketIOServer;

import cn.jasonone.him.model.HimFriend;
import cn.jasonone.him.model.HimUserInfo;
import cn.jasonone.him.service.HimService;
import cn.jasonone.him.util.HimUtil;

@Component
public class Him implements HimMBean {
	@Resource
	private HimService himService;
	@Resource
	private SocketIOServer server;
	
	@Override
	public List<HimUserInfo> getClients() {
		Collection<SocketIOClient> clients = server.getAllClients();
		return clients.stream().map(socket -> HimUtil.getUserInfo(socket)).collect(Collectors.toList());
	}

	@Override
	public List<String> getGroups() {
		List<String> list = new ArrayList<>();
		server.getAllClients().stream().map(c -> c.getAllRooms()).forEach(r -> list.addAll(r));
		return list.stream().distinct().collect(Collectors.toList());
	}

	@Override
	public List<String> getGroups(String userId) {
		List<String> list = new ArrayList<>();
		Stream<Set<String>> stream = getClients().stream().filter(c->c.getId().equals(userId)).map(c->server.getClient(c.getSessionId()).getAllRooms());
		stream.forEach(g->list.addAll(g));
		return list;
	}

	@Override
	public List<HimUserInfo> getGroupMembers(String groupId) {
		return this.himService.findGroupById(groupId).getList();
	}

	@Override
	public List<HimFriend> getFriend(String userId) {
		return this.himService.findFriends(userId);
	}

}
