package cn.jasonone.him;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import lombok.Data;

@Data
@Configuration
@ConfigurationProperties("him")
public class HimProperties {
	/**
	 * 服务端口,默认:8088
	 */
	private int port = 8088;
	/**
	 * 心跳超时时间(单位秒): 默认60s
	 */
	private int heartbeatTimeout = 60;
	/**
	 * 心跳发送间隔时间(单位秒): 默认25s
	 */
	private int heartbeatInterval = 25;
	/**
	 * 允许访问域名
	 */
	private String origin=":*:";
	/**
	 * 访问域名
	 */
	private String hostname;
}
