package cn.jants.common.enums;

/**
 * @author MrShun
 * @version 1.0
 */
public enum Regex {

    /**
     * 不存在
     */
    NONE(null, ""),

    /**
     * Email正则表达式="^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";
     */
    //public static final String EMAIL = "^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";;
    EMAIL("\\w+(\\.\\w+)*@\\w+(\\.\\w+)+", "必须是邮箱"),
    /**
     * 电话号码正则表达式= (^(\d{2,4}[-_－—]?)?\d{3,8}([-_－—]?\d{3,8})?([-_－—]?\d{1,7})?$)|(^0?1[35]\d{9}$)
     */
    PHONE("(^(\\d{2,4}[-_－—]?)?\\d{3,8}([-_－—]?\\d{3,8})?([-_－—]?\\d{1,7})?$)|(^0?1[35]\\d{9}$)", "必须是手机号码"),
    /**
     * 手机号码正则表达式=^(13[0-9]|14[0-9]|15[0-9]|17[0-9]|18[0-9])\d{8}$
     */
    MOBILE("^(13[0-9]|14[0-9]|15[0-9]|17[0-9]|18[0-9])\\d{8}$", "必须是手机号码"),

    /**
     * Integer正则表达式 ^-?(([1-9]\d*$)|0)
     */
    INTEGER("^-?(([1-9]\\d*$)|0)", "必须是Integer类型"),

    INTEGER_NEGATIVE("^[1-9]\\d*|0$", "必须是正整数"),

    INTEGER_POSITIVE("^-[1-9]\\d*|0$", "必须是负整数"),
    /**
     * Double正则表达式 ^-?([1-9]\d*\.\d*|0\.\d*[1-9]\d*|0?\.0+|0)$
     */
    DOUBLE("^-?([1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*|0?\\.0+|0)$", "必须是Double"),

    DOUBLE_NEGATIVE("^[1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*|0?\\.0+|0$", "必须是正Double"),

    DOUBLE_POSITIVE("^(-([1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*))|0?\\.0+|0$", "必须是负Double"),
    /**
     * 年龄正则表达式 ^(?:[1-9][0-9]?|1[01][0-9]|120)$ 匹配0-120岁
     */
    AGE("^(?:[1-9][0-9]?|1[01][0-9]|120)$", "必须是年龄0-120岁"),
    /**
     * 邮编正则表达式  [0-9]\d{5}(?!\d) 国内6位邮编
     */
    CODE("[0-9]\\d{5}(?!\\d)", "必须是邮编号码"),
    /**
     * 匹配由数字、26个英文字母或者下划线组成的字符串 ^\w+$
     */
    STR_ENG_NUM_("^\\w+$", "必须由数字、26个英文字母或者下划线组成的字符串"),
    /**
     * 匹配由数字和26个英文字母组成的字符串 ^[A-Za-z0-9]+$
     */
    STR_ENG_NUM("^[A-Za-z0-9]+", "必须由数字和26个英文字母组成的字符串"),
    /**
     * 匹配由26个英文字母组成的字符串  ^[A-Za-z]+$
     */
    STR_ENG("^[A-Za-z]+$", "必须由26个英文字母组成的字符串"),
    /**
     * 过滤特殊字符串正则
     */
    STR_SPECIAL("[`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~！@#￥%……&*（）——+|{}【】‘；：”“’。，、？]", "不能是非法字符"),
    /***
     * 日期正则 支持：
     * YYYY-MM-DD
     * YYYY/MM/DD
     * YYYY_MM_DD
     * YYYYMMDD
     * YYYY.MM.DD的形式
     */
    DATE_ALL("((^((1[8-9]\\d{2})|([2-9]\\d{3}))([-\\/\\._]?)(10|12|0?[13578])([-\\/\\._]?)(3[01]|[12][0-9]|0?[1-9])$)" +
            "|(^((1[8-9]\\d{2})|([2-9]\\d{3}))([-\\/\\._]?)(11|0?[469])([-\\/\\._]?)(30|[12][0-9]|0?[1-9])$)" +
            "|(^((1[8-9]\\d{2})|([2-9]\\d{3}))([-\\/\\._]?)(0?2)([-\\/\\._]?)(2[0-8]|1[0-9]|0?[1-9])$)|(^([2468][048]00)([-\\/\\._]?)(0?2)([-\\/\\._]?)(29)$)|(^([3579][26]00)" +
            "([-\\/\\._]?)(0?2)([-\\/\\._]?)(29)$)" +
            "|(^([1][89][0][48])([-\\/\\._]?)(0?2)([-\\/\\._]?)(29)$)|(^([2-9][0-9][0][48])([-\\/\\._]?)" +
            "(0?2)([-\\/\\._]?)(29)$)" +
            "|(^([1][89][2468][048])([-\\/\\._]?)(0?2)([-\\/\\._]?)(29)$)|(^([2-9][0-9][2468][048])([-\\/\\._]?)(0?2)" +
            "([-\\/\\._]?)(29)$)|(^([1][89][13579][26])([-\\/\\._]?)(0?2)([-\\/\\._]?)(29)$)|" +
            "(^([2-9][0-9][13579][26])([-\\/\\._]?)(0?2)([-\\/\\._]?)(29)$))", "必须是 YYYY-MM-DD、YYYY/MM/DD、YYYY_MM_DD、YYYYMMDD、YYYY.MM.DD 日期格式"),
    /***
     * 日期正则 支持：
     * YYYY-MM-DD
     */
    DATE_FORMAT1("(([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12]" +
            "[0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|" +
            "((0[48]|[2468][048]|[3579][26])00))-02-29)", "必须是 YYYY-MM-DD 日期格式"),

    /**
     * URL正则表达式
     * 匹配 http www ftp
     */
    URL("^(http|https|www|ftp|)?(://)?(\\w+(-\\w+)*)(\\.(\\w+(-\\w+)*))*((:\\d+)?)(/(\\w+(-\\w+)*))*(\\.?(\\w)*)(\\?)?" +
            "(((\\w*%)*(\\w*\\?)*(\\w*:)*(\\w*\\+)*(\\w*\\.)*(\\w*&)*(\\w*-)*(\\w*=)*(\\w*%)*(\\w*\\?)*" +
            "(\\w*:)*(\\w*\\+)*(\\w*\\.)*" +
            "(\\w*&)*(\\w*-)*(\\w*=)*)*(\\w*)*)$", "必须是URL链接"),

    /**
     * 身份证正则表达式
     */
    IDCARD("((11|12|13|14|15|21|22|23|31|32|33|34|35|36|37|41|42|43|44|45|46|50|51|52|53|54|61|62|63|64|65)[0-9]{4})" +
            "(([1|2][0-9]{3}[0|1][0-9][0-3][0-9][0-9]{3}" +
            "[Xx0-9])|([0-9]{2}[0|1][0-9][0-3][0-9][0-9]{3}))", "必须是身份证号"),

    /**
     * 机构代码
     */
    JIGOU_CODE("^[A-Z0-9]{8}-[A-Z0-9]$", "必须是机构代码"),

    /**
     * 匹配数字组成的字符串  ^[0-9]+$
     */
    STR_NUM("^[0-9]+$", "必须是数字组成的字符串");

    Regex(String regex, String msg) {
        this.regex = regex;
        this.msg = msg;
    }

    private String regex;

    private String msg;

    public String getRegex() {
        return regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}
