/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.restful.request;

import cn.jants.common.annotation.action.Controller;
import cn.jants.common.annotation.action.DELETE;
import cn.jants.common.annotation.action.GET;
import cn.jants.common.annotation.action.POST;
import cn.jants.common.annotation.action.PUT;
import cn.jants.common.enums.RequestMethod;
import cn.jants.core.context.AppConstant;
import cn.jants.core.ext.InitializingBean;
import cn.jants.core.proxy.CglibProxy;
import cn.jants.core.proxy.FiledBinding;
import cn.jants.restful.request.RequestMappingBean;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public class ActionInitialization {
    public static List<RequestMappingBean> createRequestMapping(List<Class<?>> ctls) {
        ArrayList<RequestMappingBean> result = new ArrayList<RequestMappingBean>();
        ArrayList<String> keys = new ArrayList<String>();
        for (Class<?> ctl : ctls) {
            try {
                Method[] methods;
                Object ctlObj = ctl.newInstance();
                FiledBinding.initFiledValues(ctlObj);
                Object proxy = CglibProxy.createProxy(ctlObj);
                if (proxy instanceof InitializingBean) {
                    InitializingBean ib = (InitializingBean)proxy;
                    ib.afterPropertiesSet();
                }
                Controller ctlAnno = ctl.getDeclaredAnnotation(Controller.class);
                for (Method method : methods = ctl.getDeclaredMethods()) {
                    if (Modifier.isStatic(method.getModifiers()) || method.getClass().isPrimitive()) continue;
                    RequestMethod requestType = null;
                    String[] strUrls = new String[]{method.getName()};
                    POST post = method.getDeclaredAnnotation(POST.class);
                    if (post != null) {
                        requestType = RequestMethod.POST;
                        strUrls = post.value();
                    } else {
                        GET get = method.getDeclaredAnnotation(GET.class);
                        if (get != null) {
                            requestType = RequestMethod.GET;
                            strUrls = get.value();
                        } else {
                            PUT put = method.getDeclaredAnnotation(PUT.class);
                            if (put != null) {
                                requestType = RequestMethod.PUT;
                                strUrls = put.value();
                            } else {
                                DELETE delete = method.getDeclaredAnnotation(DELETE.class);
                                if (delete != null) {
                                    requestType = RequestMethod.DELETE;
                                    strUrls = delete.value();
                                }
                            }
                        }
                    }
                    String[] urls = ActionInitialization.join(ctlAnno.value(), ActionInitialization.formatURLs(strUrls, AppConstant.URL_REGEX_SUFFIX));
                    RequestMappingBean bean = new RequestMappingBean(urls, null, requestType, ctlObj, proxy, method);
                    for (String key : urls) {
                        if (keys.contains(key)) {
                            throw new RuntimeException(key + " \u5b58\u5728\u76f8\u540c\u7684URL\u94fe\u63a5, \u521d\u59cb\u5316\u5931\u8d25!");
                        }
                        keys.add(key);
                    }
                    result.add(bean);
                }
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                break;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                break;
            }
        }
        return result;
    }

    private static String[] formatURLs(String[] urls, String regexSuffix) {
        if (urls != null && urls.length != 0) {
            for (int i = 0; i < urls.length; ++i) {
                String url = urls[i].indexOf(47) != 0 ? "/".concat(urls[i]) : urls[i];
                urls[i] = url.indexOf(".", url.lastIndexOf("/")) == -1 ? url.trim() + regexSuffix : url.trim();
            }
        }
        return urls;
    }

    private static String[] join(String moduleStr, String[] urls) {
        if (moduleStr.indexOf(47) != 0 && !"".equals(moduleStr)) {
            moduleStr = "/" + moduleStr;
        }
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = moduleStr.trim() + urls[i];
        }
        return urls;
    }
}

