/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.plugin.template;

import cn.jants.common.annotation.boot.ViewConfiguration;
import cn.jants.common.bean.JsonMap;
import cn.jants.common.enums.LoadType;
import cn.jants.restful.render.ModelAndView;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FreeMarkerTpl {
    private Configuration configuration;
    private String tplDir;
    private LoadType loadType;

    public FreeMarkerTpl(ViewConfiguration viewConfiguration) {
        this.tplDir = viewConfiguration.loadPath();
        this.loadType = viewConfiguration.loadType();
        this.configuration = new Configuration();
        this.configuration.setTemplateUpdateDelay(viewConfiguration.updateDelay());
        this.configuration.setDefaultEncoding(viewConfiguration.encoding());
        this.configuration.setClassicCompatible(true);
        this.configuration.setOutputEncoding(viewConfiguration.encoding());
        if (this.loadType == LoadType.FilePath) {
            try {
                this.configuration.setDirectoryForTemplateLoading(new File(this.tplDir));
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(this.tplDir + " \u6ca1\u6709\u627e\u5230\u6a21\u677f\u76ee\u5f55!");
            }
        } else {
            this.configuration.setClassForTemplateLoading(Thread.currentThread().getClass(), this.tplDir);
        }
    }

    public void setTplDir(String tplDir) {
        if (this.loadType == LoadType.FilePath) {
            try {
                this.configuration.setDirectoryForTemplateLoading(new File(tplDir));
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(tplDir + " \u6ca1\u6709\u627e\u5230\u6a21\u677f\u76ee\u5f55!");
            }
        } else {
            this.configuration.setClassForTemplateLoading(Thread.currentThread().getClass(), tplDir);
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    private void render(String viewName, ModelAndView modelAndView, HttpServletRequest request, HttpServletResponse response) {
        Enumeration attributeNames = request.getAttributeNames();
        JsonMap model = JsonMap.newJsonMap();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            model.put(attributeName, request.getAttribute(attributeName));
        }
        try {
            Template template;
            Template template2 = template = viewName != null ? this.configuration.getTemplate(viewName) : this.configuration.getTemplate(modelAndView.getView());
            if (modelAndView != null) {
                model.putAll(modelAndView.getModel());
            }
            template.process((Object)model, (Writer)response.getWriter());
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage() + " \u6ca1\u6709\u6307\u5b9a\u4efb\u4f55\u89c6\u56fe\u6a21\u677f!");
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
    }

    public void render(String viewName, HttpServletRequest request, HttpServletResponse response) {
        this.render(viewName, null, request, response);
    }

    public void render(ModelAndView modelAndView, HttpServletRequest request, HttpServletResponse response) {
        this.render(null, modelAndView, request, response);
    }
}

