/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.plugin.sqlmap.node;

import cn.jants.plugin.sqlmap.node.SqlNode;
import java.util.Collection;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ForEachSqlNode
implements SqlNode {
    private String collection;
    private String item;
    private String separator;
    private String open;
    private String close;
    private String context;

    public ForEachSqlNode(Node node) {
        Element el = (Element)node;
        this.collection = el.getAttribute("collection");
        this.item = el.getAttribute("item");
        this.separator = el.getAttribute("separator");
        this.open = el.getAttribute("open");
        this.close = el.getAttribute("close");
        this.context = el.getTextContent().trim();
    }

    private String list(Collection collection) {
        String sbx = "";
        for (Object o : collection) {
            String temp = "";
            if (o instanceof String) {
                temp = this.context.replace("#{" + this.item + "}", "'" + o + "'");
            } else if (o instanceof Integer) {
                temp = this.context.replace("#{" + this.item + "}", String.valueOf(o));
            } else {
                throw new RuntimeException("list can only store strings or integers!");
            }
            sbx = sbx + temp + this.separator;
        }
        return sbx;
    }

    private String array(Object[] objs) {
        String sbx = "";
        if (objs != null) {
            for (Object obj : objs) {
                String temp = "";
                if (obj instanceof String) {
                    temp = this.context.replace("#{" + this.item + "}", "'" + obj + "'");
                } else if (obj instanceof Integer) {
                    temp = this.context.replace("#{" + this.item + "}", String.valueOf(obj));
                } else {
                    throw new RuntimeException("arrays can only store strings or integers!");
                }
                sbx = sbx + temp + this.separator;
            }
        }
        return sbx;
    }

    @Override
    public String getResult(Object obj) {
        StringBuffer sb = new StringBuffer(this.open);
        String sbx = "";
        if (obj instanceof Collection) {
            sbx = this.list((Collection)obj);
        } else if (obj instanceof Object[]) {
            sbx = this.array((Object[])obj);
        } else if (obj instanceof Map) {
            Object result = ((Map)obj).get(this.collection);
            if (result instanceof Collection) {
                sbx = this.list((Collection)result);
            } else if (result instanceof Object[]) {
                sbx = this.array((Object[])result);
            } else {
                throw new IllegalArgumentException(this.collection + " can only store collections or arrays!");
            }
        }
        if (!sbx.isEmpty()) {
            sbx = sbx.substring(0, sbx.length() - this.separator.length());
        }
        sb.append(sbx + this.close);
        return sb.toString();
    }
}

