/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.plugin.sqlmap;

import cn.jants.common.bean.JsonMap;
import cn.jants.common.bean.PageConditions;
import cn.jants.common.utils.StrUtil;
import cn.jants.core.module.DbManager;
import cn.jants.plugin.db.Db;
import cn.jants.plugin.sqlmap.Paging;
import cn.jants.plugin.sqlmap.SqlParams;
import cn.jants.plugin.sqlmap.SqlParser;
import cn.jants.plugin.sqlmap.TagElement;
import cn.jants.plugin.sqlmap.annotation.Mapper;
import cn.jants.plugin.sqlmap.annotation.P;
import cn.jants.plugin.sqlmap.annotation.Sql;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MapperProxy
implements InvocationHandler {
    private String mapperName;
    private Class<?> targetCls;

    public MapperProxy(String mapperName, Class targetCls) {
        this.mapperName = mapperName;
        this.targetCls = targetCls;
    }

    public Object getProxy() {
        return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{this.targetCls}, (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> cls;
        SqlParams sqlParams;
        String resultType;
        String optionType;
        Object result = null;
        String sqlKey = this.mapperName.concat(".").concat(method.getName());
        Mapper mapper = this.targetCls.getDeclaredAnnotation(Mapper.class);
        Db db = DbManager.get(mapper.value());
        Class<?> methodReturnType = method.getReturnType();
        Sql sql = method.getDeclaredAnnotation(Sql.class);
        if (sql == null || StrUtil.isBlank(sql.value())) {
            TagElement tagElement = SqlParser.getOptionType(sqlKey);
            optionType = tagElement.getOptionType();
            resultType = tagElement.getResultType();
            if (args == null || args[0] == null) {
                sqlParams = SqlParser.getPreparedStatement(sqlKey);
            } else if (args.length == 1) {
                Object param = args[0];
                cls = param.getClass();
                if (cls.getClassLoader() != null && !(param instanceof Map)) {
                    Field[] fields;
                    JsonMap map = JsonMap.newJsonMap();
                    for (Field field : fields = cls.getDeclaredFields()) {
                        field.setAccessible(true);
                        Object value = field.get(param);
                        if (!StrUtil.notNull(value)) continue;
                        map.put(field.getName(), value);
                    }
                    sqlParams = SqlParser.getPreparedStatement(sqlKey, map);
                } else {
                    sqlParams = SqlParser.getPreparedStatement(sqlKey, param);
                }
            } else {
                JsonMap params = JsonMap.newJsonMap();
                Parameter[] parameters = method.getParameters();
                for (int i = 0; i < args.length; ++i) {
                    P p = parameters[i].getDeclaredAnnotation(P.class);
                    if (p != null) {
                        if (args[i] == null) continue;
                        params.put(p.value(), args[i]);
                        continue;
                    }
                    throw new RuntimeException("\u63a5\u53e3\u53c2\u6570\u8d85\u8fc71\u4e2a\u5fc5\u987b\u91c7\u7528@P\u6ce8\u89e3\u7ed1\u5b9a!");
                }
                sqlParams = SqlParser.getPreparedStatement(sqlKey, params);
            }
        } else {
            sqlParams = new SqlParams(sql.value(), args);
            resultType = sql.resultType();
            optionType = sql.type().getValue();
        }
        if ("select".equals(optionType)) {
            String strObject;
            if (methodReturnType == List.class) {
                if (StrUtil.isBlank(resultType)) {
                    throw new RuntimeException("List\u8fd4\u56de\u503c\u5fc5\u987b\u914d\u7f6eresultType\u7c7b\u578b!");
                }
                if ("map".equals(resultType) || "hashmap".equals(resultType) || "jsonmap".equals(resultType)) {
                    PageConditions pageConditions = Paging.getPageConditions();
                    if (pageConditions == null) {
                        result = db.list(sqlParams.getSql(), sqlParams.getParams());
                    } else {
                        pageConditions.setParams(sqlParams.getParams());
                        result = db.page(sqlParams.getSql(), pageConditions);
                    }
                } else if ("long".equals(resultType) || "integer".equals(resultType) || "string".equals(resultType)) {
                    result = db.listOne(sqlParams.getSql(), sqlParams.getParams());
                    strObject = String.valueOf(result);
                    result = "long".equals(resultType) ? Long.valueOf(strObject) : ("integer".equals(resultType) ? Integer.valueOf(strObject) : strObject);
                } else {
                    String idKey = this.mapperName.concat(".").concat(resultType);
                    String type = SqlParser.getResultType(idKey);
                    cls = Class.forName(StrUtil.isBlank(type) ? resultType : type);
                    PageConditions pageConditions = Paging.getPageConditions();
                    if (pageConditions == null) {
                        result = db.list(sqlParams.getSql(), cls, sqlParams.getParams());
                    } else {
                        pageConditions.setParams(sqlParams.getParams());
                        result = db.page(sqlParams.getSql(), cls, pageConditions);
                    }
                }
                Paging.remove();
            } else if (methodReturnType == JsonMap.class || methodReturnType == HashMap.class || methodReturnType == Map.class) {
                result = db.query(sqlParams.getSql(), sqlParams.getParams());
            } else if (methodReturnType == Long.class || methodReturnType == Long.TYPE || methodReturnType == Integer.class || methodReturnType == Integer.TYPE || methodReturnType == String.class) {
                result = db.queryOne(sqlParams.getSql(), sqlParams.getParams());
                strObject = String.valueOf(result);
                result = methodReturnType == Long.class || methodReturnType == Long.TYPE ? Long.valueOf(strObject) : (methodReturnType == Integer.class || methodReturnType == Integer.TYPE ? Integer.valueOf(strObject) : strObject);
            } else if (methodReturnType.getClassLoader() != null) {
                result = db.query(sqlParams.getSql(), methodReturnType, sqlParams.getParams());
            }
        } else if ("insert".equals(optionType)) {
            if (methodReturnType == Void.TYPE) {
                db.insert(sqlParams.getSql(), sqlParams.getParams());
            } else {
                result = db.insertReturnKey(sqlParams.getSql(), sqlParams.getParams());
            }
        } else if ("update".equals(optionType) || "delete".equals(optionType)) {
            if (methodReturnType == Void.TYPE) {
                db.update(sqlParams.getSql(), sqlParams.getParams());
            } else {
                result = db.update(sqlParams.getSql(), sqlParams.getParams());
            }
        }
        return result;
    }
}

