/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.plugin.orm;

import cn.jants.common.utils.StrCaseUtil;
import cn.jants.common.utils.StrUtil;
import cn.jants.plugin.orm.Cond;
import cn.jants.plugin.orm.enums.Condition;
import cn.jants.plugin.orm.enums.OrderBy;
import cn.jants.plugin.orm.enums.Relation;
import cn.jants.plugin.orm.enums.Symbol;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Conditions {
    private String label = "*";
    private String orderBy;
    private String groupBy;
    private String limit;
    private List<String> relations = new ArrayList<String>();
    private List<Cond> conditions = new ArrayList<Cond>();

    public Conditions limit(Integer start, Integer size) {
        this.limit = String.format(" limit %s,%s", start, size);
        return this;
    }

    public String getLimit() {
        return this.limit;
    }

    public Conditions addRelation(Relation relation, String table, String alias, String cond1, String cond2) {
        this.relations.add(String.format(relation.getValue(), table, alias, cond1, cond2));
        return this;
    }

    public Conditions addRelation(Relation relation, String table, String cond1, String cond2) {
        this.relations.add(String.format(relation.getValue(), table, "", cond1, cond2));
        return this;
    }

    public List<String> getRelations() {
        return this.relations;
    }

    public Conditions label(String ... labels) {
        if (labels.length == 1) {
            this.label = " ".concat(labels[0]);
        } else {
            StringBuffer sb = new StringBuffer(" ");
            for (String label : labels) {
                String asStr = label.indexOf(".") != -1 ? label.substring(label.indexOf(".") + 1, label.length()) : label;
                sb.append(label).append(" as ").append(StrCaseUtil.toCapital(asStr, false)).append(",");
            }
            sb.delete(sb.length() - 1, sb.length());
            this.label = sb.toString();
        }
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public List<Cond> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<Cond> conditions) {
        this.conditions = conditions;
    }

    public Conditions orderBy(OrderBy orderBy, String ... fields) {
        if (fields.length == 1) {
            this.orderBy = String.format(orderBy.getValue(), fields[0]);
        } else {
            StringBuffer sb = new StringBuffer();
            for (String field : fields) {
                sb.append(field).append(",");
            }
            sb.delete(sb.length() - 1, sb.length());
            this.orderBy = String.format(orderBy.getValue(), sb.toString());
        }
        return this;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public Conditions groupBy(String field) {
        this.groupBy = field;
        return this;
    }

    public String getGroupBy() {
        return this.groupBy;
    }

    public Conditions and(String field, Condition condition, Object ... value) {
        this.conditions.add(new Cond(Symbol.AND, field, condition, value));
        return this;
    }

    public Conditions or(String field, Condition condition, Object ... value) {
        this.conditions.add(new Cond(Symbol.OR, field, condition, value));
        return this;
    }

    public Conditions clear() {
        this.conditions.clear();
        this.relations.clear();
        this.label = "*";
        this.orderBy = null;
        this.limit = null;
        return this;
    }

    public Conditions filters(String filters) {
        JSONObject jsonObject = JSON.parseObject((String)filters);
        Set entries = jsonObject.entrySet();
        for (Map.Entry entry : entries) {
            Object value = entry.getValue();
            if (!StrUtil.notBlank(String.valueOf(value))) continue;
            this.and((String)entry.getKey(), Condition.EQ, value);
        }
        return this;
    }
}

