/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.plugin.jms;

import cn.jants.common.bean.JsonMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;

public class ActiveMqTpl {
    private Session session;
    private ThreadLocal<Map<String, MessageProducer>> threadLocal = new ThreadLocal();

    public ActiveMqTpl(Session session) {
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    public void send(String queueName, String message) {
        try {
            MessageProducer messageProducer;
            Queue queue = this.session.createQueue(queueName);
            Map<String, MessageProducer> current = this.threadLocal.get();
            if (current != null) {
                messageProducer = current.get(queueName);
                if (messageProducer == null) {
                    messageProducer = this.session.createProducer((Destination)queue);
                    this.threadLocal.set(JsonMap.newJsonMap().set(queueName, messageProducer));
                }
            } else {
                messageProducer = this.session.createProducer((Destination)queue);
                this.threadLocal.set(JsonMap.newJsonMap().set(queueName, messageProducer));
            }
            TextMessage textMessage = this.session.createTextMessage(message);
            messageProducer.send((Message)textMessage);
            this.session.commit();
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }
}

