/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.plugin.db;

import cn.jants.core.ext.Plugin;
import cn.jants.plugin.db.CommonProperty;
import com.alibaba.druid.filter.Filter;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.alibaba.fastjson.JSON;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;

public class DruidPlugin
extends CommonProperty
implements Plugin {
    private int initialSize = 10;
    private int minIdle = 5;
    private int maxActive = 50;
    private long maxWait = -1L;
    private long timeBetweenEvictionRunsMillis = 60000L;
    private long minEvictableIdleTimeMillis = 1800000L;
    private long timeBetweenConnectErrorMillis = 30000L;
    private String validationQuery = "select 'x'";
    private boolean testWhileIdle = true;
    private boolean testOnBorrow = false;
    private boolean testOnReturn = false;
    private boolean removeAbandoned = true;
    private String removeAbandonedTimeout = "1800";
    private long removeAbandonedTimeoutMillis = 300000L;
    private boolean logAbandoned = false;
    private boolean poolPreparedStatements = true;
    private int maxPoolPreparedStatementPerConnectionSize = -1;
    private String filters = "stat";
    private List<Filter> filterList;
    private DataSource dataSource = null;

    public DruidPlugin(String url, String driverClassName, String username, String password) {
        super(url, driverClassName, username, password);
    }

    public DruidPlugin(String name, String url, String driverClassName, String username, String password) {
        super(name, url, driverClassName, username, password);
    }

    public String getInitialSize() {
        return String.valueOf(this.initialSize);
    }

    public void setInitialSize(int initialSize) {
        this.initialSize = initialSize;
    }

    public String getMinIdle() {
        return String.valueOf(this.minIdle);
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public String getMaxActive() {
        return String.valueOf(this.maxActive);
    }

    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public String getMaxWait() {
        return String.valueOf(this.maxWait);
    }

    public void setMaxWait(long maxWait) {
        this.maxWait = maxWait;
    }

    public String getTimeBetweenEvictionRunsMillis() {
        return String.valueOf(this.timeBetweenEvictionRunsMillis);
    }

    public void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public String getMinEvictableIdleTimeMillis() {
        return String.valueOf(this.minEvictableIdleTimeMillis);
    }

    public void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public String getTimeBetweenConnectErrorMillis() {
        return String.valueOf(this.timeBetweenConnectErrorMillis);
    }

    public void setTimeBetweenConnectErrorMillis(long timeBetweenConnectErrorMillis) {
        this.timeBetweenConnectErrorMillis = timeBetweenConnectErrorMillis;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    public String isTestWhileIdle() {
        return String.valueOf(this.testWhileIdle);
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
    }

    public String isTestOnBorrow() {
        return String.valueOf(this.testOnBorrow);
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    public String isTestOnReturn() {
        return String.valueOf(this.testOnReturn);
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
    }

    public String isRemoveAbandoned() {
        return String.valueOf(this.removeAbandoned);
    }

    public void setRemoveAbandoned(boolean removeAbandoned) {
        this.removeAbandoned = removeAbandoned;
    }

    public String getRemoveAbandonedTimeout() {
        return this.removeAbandonedTimeout;
    }

    public void setRemoveAbandonedTimeout(String removeAbandonedTimeout) {
        this.removeAbandonedTimeout = removeAbandonedTimeout;
    }

    public String getRemoveAbandonedTimeoutMillis() {
        return String.valueOf(this.removeAbandonedTimeoutMillis);
    }

    public void setRemoveAbandonedTimeoutMillis(long removeAbandonedTimeoutMillis) {
        this.removeAbandonedTimeoutMillis = removeAbandonedTimeoutMillis;
    }

    public String isLogAbandoned() {
        return String.valueOf(this.logAbandoned);
    }

    public void setLogAbandoned(boolean logAbandoned) {
        this.logAbandoned = logAbandoned;
    }

    public String getMaxPoolPreparedStatementPerConnectionSize() {
        return String.valueOf(this.maxPoolPreparedStatementPerConnectionSize);
    }

    public void setMaxPoolPreparedStatementPerConnectionSize(int maxPoolPreparedStatementPerConnectionSize) {
        this.maxPoolPreparedStatementPerConnectionSize = maxPoolPreparedStatementPerConnectionSize;
    }

    public String getFilters() {
        return this.filters;
    }

    public void setFilters(String filters) {
        this.filters = filters;
    }

    public List<Filter> getFilterList() {
        return this.filterList;
    }

    public void setFilterList(List<Filter> filterList) {
        this.filterList = filterList;
    }

    @Override
    public boolean start() {
        try {
            Properties config = (Properties)JSON.parseObject((String)JSON.toJSONString((Object)this), Properties.class);
            this.dataSource = DruidDataSourceFactory.createDataSource((Properties)config);
            this.test("test druid dataSource!", this.dataSource);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean destroy() {
        try {
            this.dataSource.getConnection().close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.dataSource = null;
        }
        return true;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public DataSource getDataSource(Properties properties) {
        try {
            Properties config = (Properties)JSON.parseObject((String)JSON.toJSONString((Object)this), Properties.class);
            config.putAll((Map<?, ?>)properties);
            DataSource dataSource = DruidDataSourceFactory.createDataSource((Properties)config);
            return dataSource;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

