/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.plugin.cache;

import cn.jants.common.bean.Log;
import cn.jants.common.utils.StrUtil;
import cn.jants.core.ext.Plugin;
import cn.jants.core.module.ServiceManager;
import cn.jants.plugin.cache.RedisTpl;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.util.Pool;

public class RedisPlugin
implements Plugin {
    private String host;
    private String password;
    private int port;
    private int database;
    private Integer maxTotal = 500;
    private Integer maxIdle = 60000;
    private Integer maxWaitMillis = 10000;

    public RedisPlugin(String host, int port, Integer database, String password) {
        this.host = host;
        this.port = port;
        this.database = database;
        this.password = password;
    }

    @Override
    public boolean start() throws Exception {
        try {
            Jedis jedis = new Jedis(this.host, this.port);
            JedisPoolConfig config = new JedisPoolConfig();
            config.setMaxTotal(this.maxTotal.intValue());
            config.setMaxIdle(this.maxIdle.intValue());
            config.setMaxWaitMillis((long)this.maxWaitMillis.intValue());
            config.setTestOnBorrow(true);
            jedis.setDataSource((Pool)new JedisPool((GenericObjectPoolConfig)config, this.host, this.port));
            if (StrUtil.notBlank(this.password)) {
                jedis.auth(this.password);
            }
            jedis.select(this.database);
            Log.debug("db > db{} , Redis\u8fde\u63a5\u6210\u529f... ", this.database);
            RedisTpl redisTpl = new RedisTpl(jedis);
            ServiceManager.setService("plugin_cache_RedisTpl", redisTpl);
            return true;
        }
        catch (Exception e) {
            Log.error("Redis\u8fde\u63a5\u5931\u8d25, \u8bf7\u8ba4\u771f\u68c0\u67e5\u914d\u7f6e ... ", e.getMessage());
            throw new Exception(e);
        }
    }

    @Override
    public boolean destroy() {
        return true;
    }
}

