/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.core.proxy;

import cn.jants.core.proxy.AopManager;
import cn.jants.core.proxy.CacheManager;
import cn.jants.core.proxy.TransactionManager;
import java.lang.reflect.Method;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.InvocationHandler;

public class CglibProxy
implements InvocationHandler {
    private Object target;

    private CglibProxy(Object target) {
        this.target = target;
    }

    public static <T> T createProxy(Object target) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(target.getClass());
        enhancer.setCallback((Callback)new CglibProxy(target));
        return (T)enhancer.create();
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        method.setAccessible(true);
        CacheManager cacheManager = new CacheManager(this.target, method, args);
        if (cacheManager.isOpened() && cacheManager.existCache()) {
            return cacheManager.getResult();
        }
        TransactionManager tx = new TransactionManager(this.target, method);
        try {
            result = AopManager.handler(this.target, method, args);
            tx.commit();
            if (cacheManager.isOpened()) {
                cacheManager.setCache(result);
            }
        }
        catch (Exception e) {
            tx.rollback();
            throw e.getCause();
        }
        return result;
    }
}

