/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.core.module;

import cn.jants.common.annotation.service.Service;
import cn.jants.common.bean.Log;
import cn.jants.core.context.AppConstant;
import cn.jants.core.ext.InitializingBean;
import cn.jants.core.proxy.CglibProxy;
import cn.jants.core.proxy.FiledBinding;
import cn.jants.core.utils.GenerateUtil;
import cn.jants.core.utils.ScanUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ServiceManager {
    private static final Map<String, Object> SERVICES = new ConcurrentHashMap<String, Object>();

    public static void register(String ... packages) {
        List<Class<?>> sers = ScanUtil.findScanClass(packages, Service.class);
        for (Class<?> ser : sers) {
            String serName = ser.getName();
            String key = GenerateUtil.createServiceKey(serName);
            if (AppConstant.DEBUG.booleanValue()) {
                Log.debug(">>> {} :: Generator Success !", key);
            }
            if (SERVICES.containsKey(key)) continue;
            try {
                Object serObj = ser.newInstance();
                FiledBinding.initFiledValues(serObj);
                Object proxy = CglibProxy.createProxy(serObj);
                if (proxy instanceof InitializingBean) {
                    InitializingBean ib = (InitializingBean)proxy;
                    ib.afterPropertiesSet();
                }
                SERVICES.put(key, proxy);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (AppConstant.DEBUG.booleanValue()) {
            Log.debug(">>> \u5171\u8ba1 {} \u4e2a\u670d\u52a1", sers.size());
        }
    }

    public static Object getService(String key) {
        return SERVICES.get(key);
    }

    public static Object setService(String key, Object object) {
        return SERVICES.put(key, object);
    }

    public static <T> T getService(Class<T> cls) {
        Map.Entry<String, Object> entry;
        Object object = null;
        Iterator<Map.Entry<String, Object>> iterator = SERVICES.entrySet().iterator();
        while (iterator.hasNext() && !cls.isInstance(object = (entry = iterator.next()).getValue())) {
        }
        return (T)object;
    }
}

