/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.core.module;

import cn.jants.core.ext.Plugin;
import cn.jants.plugin.db.CommonProperty;
import java.util.ArrayList;
import java.util.List;

public final class PluginManager {
    private static final List<Plugin> PLUGINS = new ArrayList<Plugin>();

    public PluginManager add(Plugin plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException("plugin can not be null");
        }
        PLUGINS.add(plugin);
        return this;
    }

    public static List<Plugin> getPluginList() {
        return PLUGINS;
    }

    public static <T> T findPluginObject(Class<T> clsType) {
        for (Plugin obj : PLUGINS) {
            if (obj.getClass() != clsType) continue;
            return (T)obj;
        }
        return null;
    }

    public static <T> T findSourcePluginObject(Class<T> clsType, String name) {
        for (Plugin obj : PLUGINS) {
            CommonProperty ct;
            if (obj.getClass() != clsType || !name.equals((ct = (CommonProperty)((Object)obj)).getName())) continue;
            return (T)obj;
        }
        return null;
    }

    public static <T> T findFirstSourcePluginObject(Class<T> clsType) {
        return PluginManager.findSourcePluginObject(clsType, "");
    }

    public static <T> T findRandomSourcePluginObject(Class<T> clsType) {
        for (Plugin obj : PLUGINS) {
            if (obj.getClass() != clsType) continue;
            CommonProperty ct = (CommonProperty)((Object)obj);
            return (T)obj;
        }
        return null;
    }
}

