/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.core.module;

import cn.jants.core.ext.Interceptor;
import cn.jants.core.interceptor.GlobalInterceptor;
import java.util.ArrayList;
import java.util.List;

public final class InterceptorManager {
    private static final List<Interceptor> INTERCEPTORS = new ArrayList<Interceptor>();
    private static GlobalInterceptor global;

    public InterceptorManager add(Interceptor interceptor) {
        if (interceptor == null) {
            throw new IllegalArgumentException("interceptor can not be null");
        }
        INTERCEPTORS.add(interceptor);
        return this;
    }

    public InterceptorManager addGlobal(Interceptor interceptor, String prefixPackage, String prefixMethod) {
        global = new GlobalInterceptor(interceptor, prefixPackage, prefixMethod);
        INTERCEPTORS.add(global.getInterceptor());
        return this;
    }

    public static GlobalInterceptor getGlobalInterceptor() {
        return global;
    }

    public InterceptorManager addGlobal(Interceptor interceptor, String pkg) {
        return this.addGlobal(interceptor, pkg, null);
    }

    public static <T> T getSameClass(Class<T> clsType) {
        for (Interceptor obj : INTERCEPTORS) {
            if (obj.getClass() != clsType) continue;
            return (T)obj;
        }
        return null;
    }
}

