/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.core.module;

import cn.jants.common.enums.ResponseCode;
import cn.jants.common.exception.SQLParamsException;
import cn.jants.common.exception.TipException;
import cn.jants.core.ext.Handler;
import cn.jants.core.module.Constant;
import cn.jants.restful.render.Json;
import com.mysql.jdbc.MysqlDataTruncation;
import com.mysql.jdbc.exceptions.jdbc4.MySQLIntegrityConstraintViolationException;
import com.mysql.jdbc.exceptions.jdbc4.MySQLSyntaxErrorException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class HandlerManager {
    private final List<Handler> handlers = new ArrayList<Handler>();
    private Constant constant;

    public HandlerManager add(Handler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("handler can not be null");
        }
        this.handlers.add(handler);
        return this;
    }

    public boolean execute(String target, HttpServletRequest request, HttpServletResponse response) {
        boolean isHandle = true;
        for (Handler handler : this.handlers) {
            try {
                isHandle = handler.preHandler(target, request, response);
                if (isHandle) continue;
                return false;
            }
            catch (InvocationTargetException e) {
                Throwable ex = e.getTargetException();
                ex.printStackTrace();
                this.errorWrite(request, response, ex);
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.errorWrite(request, response, e);
                return false;
            }
        }
        return isHandle;
    }

    private void errorWrite(HttpServletRequest request, HttpServletResponse response, Throwable e) {
        Class<?> cls = e.getClass();
        if (cls == TipException.class) {
            TipException tipException = (TipException)e;
            Integer code = tipException.getCode();
            if (code == null) {
                Json.writeJson(Json.exception(ResponseCode.ARGUMENTS_ERROR, tipException.getMsg()), response);
            } else {
                Json.writeJson(Json.exception(code, tipException.getMsg()), response);
            }
        } else if (cls == SQLParamsException.class) {
            SQLException sqlException = ((SQLParamsException)e).getSqlException();
            Class<?> sqlClass = sqlException.getClass();
            if (sqlClass == MySQLIntegrityConstraintViolationException.class) {
                Json.writeJson(Json.exception(ResponseCode.RECORD_REF_ERROR, sqlException.getMessage()), response);
            } else if (sqlClass == MysqlDataTruncation.class) {
                Json.writeJson(Json.exception(ResponseCode.COLUMN_LONG_ERROR, sqlException.getMessage()), response);
            } else if (sqlClass == SQLException.class) {
                Json.writeJson(Json.exception(ResponseCode.SQL_PARAM_ERROR, sqlException.getMessage()), response);
            } else if (sqlClass == MySQLSyntaxErrorException.class) {
                Json.writeJson(Json.exception(ResponseCode.SQL_PARAM_ERROR, sqlException.getMessage()), response);
            }
        } else if (cls == NullPointerException.class) {
            Json.writeJson(Json.exception(ResponseCode.NULL_POINT_ERROR), response);
        } else if (cls == IllegalArgumentException.class) {
            Json.writeJson(Json.exception(ResponseCode.ARGUMENTS_ERROR, e.getMessage()), response);
        } else {
            Json.writeJson(Json.exception(ResponseCode.UNKNOWN_ERROR, e.getMessage()), response);
        }
    }

    public void setConstants(Constant constant) {
        this.constant = constant;
    }
}

