/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.core.holder;

import cn.jants.core.holder.ClientRequest;
import cn.jants.core.holder.ContextRequestManager;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ClientHolder {
    public static ClientRequest getClientRequest() {
        return ContextRequestManager.get();
    }

    public static HttpServletRequest getRequest() {
        return ContextRequestManager.get().getRequest();
    }

    public static ServletContext getContext() {
        return ContextRequestManager.get().getRequest().getServletContext();
    }

    public static HttpSession getSession() {
        return ContextRequestManager.get().getRequest().getSession();
    }

    public static HttpServletResponse getResponse() {
        return ContextRequestManager.get().getResponse();
    }

    public static String getHeader(String key) {
        return ContextRequestManager.get().getRequest().getHeader(key);
    }

    public static String getUserToken() {
        return ClientHolder.getHeader("User-Token");
    }

    public static String getUserAgent() {
        HttpServletRequest request = ContextRequestManager.get().getRequest();
        return request.getHeader("User-Agent");
    }

    public static String getIp() {
        HttpServletRequest request = ContextRequestManager.get().getRequest();
        String ip = request.getHeader("x-forwarded-for");
        if (ip != null && ip.length() != 0 && !"unknown".equalsIgnoreCase(ip) && ip.indexOf(",") != -1) {
            ip = ip.split(",")[0];
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static String getContextPath() {
        HttpServletRequest request = ContextRequestManager.get().getRequest();
        return request.getContextPath();
    }

    public static String getSessionId() {
        HttpServletRequest request = ContextRequestManager.get().getRequest();
        return request.getSession().getId();
    }

    public static void setCookie(String key, String value, int seconds) {
        Cookie userCookie = new Cookie(key, value);
        userCookie.setMaxAge(seconds);
        userCookie.setPath("/");
        ClientHolder.getResponse().addCookie(userCookie);
    }

    public static Cookie getCookie(String key) {
        Cookie[] cookies = ClientHolder.getRequest().getCookies();
        if (cookies == null || cookies.length == 0) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(key)) continue;
            return cookie;
        }
        return null;
    }

    public static void delCookie(String key) {
        Cookie cookie = ClientHolder.getCookie(key);
        if (cookie != null) {
            cookie.setPath("/");
            cookie.setMaxAge(0);
            ClientHolder.getResponse().addCookie(cookie);
        }
    }

    public static String getWebUrl(boolean isHttps) {
        HttpServletRequest request = ClientHolder.getRequest();
        int port = request.getServerPort();
        String httpStr = "http://";
        if (isHttps) {
            httpStr = "https://";
        }
        return httpStr + request.getServerName() + (port == 80 ? "" : ":" + port) + request.getContextPath() + request.getServletPath() + "?" + request.getQueryString();
    }

    public static String getWebUrl() {
        return ClientHolder.getWebUrl(false);
    }
}

