/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.common.utils;

import cn.jants.common.bean.JsonMap;
import cn.jants.common.enums.ResponseCode;
import cn.jants.common.exception.TipException;
import cn.jants.common.utils.StrEncryptUtil;
import cn.jants.common.utils.StrUtil;
import cn.jants.plugin.cache.RedisTpl;
import cn.jants.plugin.tool.RedisTool;
import java.util.Base64;

public class TokenUtil {
    private static final String CURRENT_TIME = "currentTime";
    private static final String USER_TOKEN_REDIS_PREFIX = "userToken:";
    private static final String TOKEN_ID_REDIS_PREFIX = "tokenId:";

    public static String generate(String onlyId, JsonMap userInfoExt) {
        long currentTime = System.currentTimeMillis();
        userInfoExt.put(CURRENT_TIME, (Object)currentTime);
        String str1 = StrEncryptUtil.md5(onlyId.concat("&").concat(StrUtil.randomUUID()).concat("&") + currentTime);
        byte[] bytes = str1.getBytes();
        String userTokenStr = Base64.getEncoder().encodeToString(bytes);
        RedisTpl redis = RedisTool.getRedis();
        redis.set(USER_TOKEN_REDIS_PREFIX.concat(userTokenStr), userInfoExt);
        redis.set(TOKEN_ID_REDIS_PREFIX.concat(onlyId), userTokenStr);
        return userTokenStr;
    }

    public static JsonMap checkValidity(String userTokenStr) {
        String userTokenKey;
        RedisTpl redis = RedisTool.getRedis();
        if (!redis.exists(userTokenKey = USER_TOKEN_REDIS_PREFIX.concat(userTokenStr))) {
            throw new TipException(ResponseCode.TOKEN_INVALID_INFO);
        }
        JsonMap userInfoExt = redis.get(userTokenKey, JsonMap.class);
        userInfoExt.put(CURRENT_TIME, (Object)System.currentTimeMillis());
        return userInfoExt;
    }

    public static void delUserToken(String onlyId) {
        RedisTpl redis = RedisTool.getRedis();
        String userTokenStr = redis.getStr(TOKEN_ID_REDIS_PREFIX.concat(onlyId));
        redis.remove(USER_TOKEN_REDIS_PREFIX.concat(userTokenStr));
    }

    public static JsonMap findUserInfo(String userTokenStr) {
        RedisTpl redis = RedisTool.getRedis();
        return redis.get(USER_TOKEN_REDIS_PREFIX.concat(userTokenStr), JsonMap.class);
    }

    public static String findUserToken(String onlyId) {
        RedisTpl redis = RedisTool.getRedis();
        return redis.getStr(TOKEN_ID_REDIS_PREFIX.concat(onlyId));
    }
}

