/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.restful.request;

import cn.jants.common.annotation.action.Param;
import cn.jants.common.annotation.action.PathVariable;
import cn.jants.common.bean.JsonMap;
import cn.jants.common.exception.TipException;
import cn.jants.common.utils.IOUtil;
import cn.jants.core.utils.EntityUtil;
import cn.jants.core.utils.ParamTypeUtil;
import cn.jants.restful.bind.LocalVariableTableParameterNameDiscoverer;
import cn.jants.restful.request.BindingResult;
import cn.jants.restful.request.MappingMatch;
import cn.jants.restful.request.RequestMappingBean;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;

public class BindingParams {
    private static final LocalVariableTableParameterNameDiscoverer LVP = new LocalVariableTableParameterNameDiscoverer();

    public static Object[] bingingValidate(String target, RequestMappingBean bean, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Method method = bean.getMethod();
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == 0) {
            return null;
        }
        Object[] args = new Object[parameterTypes.length];
        String[] params = LVP.getParameterNames(method);
        ArrayList<String> errMsgs = new ArrayList<String>();
        String jsonBodyStr = null;
        JSONObject jsonObject = null;
        if ("application/json".equals(request.getContentType())) {
            jsonBodyStr = IOUtil.parseStr((InputStream)request.getInputStream());
            try {
                jsonObject = JSON.parseObject((String)jsonBodyStr);
                bean.setParams(jsonObject);
            }
            catch (Exception e) {
                throw new TipException("\u5ba2\u6237\u7aef\u4e3a application/json \u683c\u5f0f, \u53c2\u6570\u8f6cjson\u5931\u8d25 params > " + jsonBodyStr + "!");
            }
        }
        block2: for (int i = 0; i < parameterTypes.length; ++i) {
            String[] parameterValues;
            Class<?> parameterType = parameterTypes[i];
            if (parameterType == HttpServletRequest.class) {
                args[i] = request;
                continue;
            }
            if (parameterType == HttpServletResponse.class) {
                args[i] = response;
                continue;
            }
            if (parameterType == HttpSession.class) {
                args[i] = request.getSession();
                continue;
            }
            if (parameterType == Part.class || parameterType == Part[].class) {
                if (parameterType.isArray()) {
                    Collection parts = request.getParts();
                    Iterator iterator = parts.iterator();
                    ArrayList list = new ArrayList();
                    while (iterator.hasNext()) {
                        Part part = (Part)iterator.next();
                        if (part.getContentType() == null) continue;
                        list.add(part);
                    }
                    args[i] = list.toArray(new Part[list.size()]);
                    continue;
                }
                args[i] = request.getPart(params[i]);
                continue;
            }
            if (parameterType == Map.class || parameterType == HashMap.class) {
                args[i] = jsonBodyStr == null ? request.getParameterMap() : JSON.parseObject((String)jsonBodyStr, Map.class);
                continue;
            }
            if (parameterType == JsonMap.class) {
                if (jsonBodyStr == null) {
                    JsonMap jsonMap = JsonMap.newJsonMap();
                    Map parameterMap = request.getParameterMap();
                    for (Map.Entry entry : parameterMap.entrySet()) {
                        String[] values = (String[])entry.getValue();
                        jsonMap.put(entry.getKey(), values.length == 1 ? values[0] : values);
                    }
                    args[i] = jsonMap;
                    continue;
                }
                args[i] = JSON.parseObject((String)jsonBodyStr, JsonMap.class);
                continue;
            }
            Annotation[][] annotations = method.getParameterAnnotations();
            if (annotations.length > 0) {
                for (int j = 0; j < annotations[i].length; ++j) {
                    Map<String, String> map;
                    Annotation annotation = annotations[i][j];
                    if (annotation instanceof PathVariable && (map = MappingMatch.getURIValues(bean.getCurrentUrl(), target)) != null) {
                        String val;
                        String pathValue = ((PathVariable)annotation).value();
                        String string = val = "".equals(pathValue) ? map.get(params[i]) : map.get(pathValue);
                        if (parameterType.isArray()) {
                            args[i] = ParamTypeUtil.parse(new String[]{val}, parameterType);
                            continue block2;
                        }
                        args[i] = ParamTypeUtil.parse(val, parameterType);
                        continue block2;
                    }
                    if (!(annotation instanceof Param)) continue;
                    Param param = (Param)annotation;
                    String regexType = param.type().getRegex();
                    String paramValue = regexType != null ? regexType : param.regex();
                    String[] parameterValues2 = request.getParameterValues(params[i]);
                    if (parameterValues2 == null || parameterValues2.length == 0) {
                        if (param.msg() == null || "".equals(param.msg())) {
                            if (regexType != null) {
                                errMsgs.add(params[i].concat(" ").concat(param.type().getMsg()));
                                continue block2;
                            }
                            errMsgs.add("the request '" + params[i] + "' parameter cannot be missing");
                            continue block2;
                        }
                        errMsgs.add(params[i].concat(" ").concat(param.msg()));
                        continue block2;
                    }
                    if (!"".equals(paramValue)) {
                        String msg;
                        String string = msg = param.msg() == null ? "the request '" + params[i] + "'  parameter validate is not passed" : param.msg();
                        if (parameterType.isArray()) {
                            for (String parameterValue : parameterValues2) {
                                if (Pattern.matches(paramValue, parameterValue)) continue;
                                errMsgs.add(msg);
                            }
                            args[i] = ParamTypeUtil.parse(parameterValues2, parameterType);
                            continue block2;
                        }
                        if (!Pattern.matches(paramValue, parameterValues2[0])) {
                            errMsgs.add(msg);
                            continue block2;
                        }
                        args[i] = ParamTypeUtil.parse(parameterValues2[0], parameterType);
                        continue block2;
                    }
                    if (parameterType.isArray()) {
                        args[i] = ParamTypeUtil.parse(parameterValues2, parameterType);
                        continue block2;
                    }
                    args[i] = ParamTypeUtil.parse(parameterValues2[0], parameterType);
                    continue block2;
                }
            }
            if (parameterType.getClassLoader() != null) {
                Object entityObj = null;
                if (jsonBodyStr == null) {
                    Field[] fields;
                    entityObj = parameterType.newInstance();
                    for (Field field : fields = parameterType.getDeclaredFields()) {
                        String[] fieldVal = request.getParameterValues(field.getName());
                        EntityUtil.optSetMethod(field, fieldVal, entityObj, errMsgs);
                    }
                } else {
                    entityObj = JSON.parseObject((String)jsonBodyStr, parameterType);
                }
                args[i] = entityObj;
                continue;
            }
            String[] stringArray = parameterValues = parameterType.isArray() ? request.getParameterValues(params[i] + "[]") : request.getParameterValues(params[i]);
            if (parameterValues != null) {
                if (parameterType.isArray()) {
                    args[i] = JSON.parseObject((String)JSON.toJSONString(ParamTypeUtil.parse(parameterValues, parameterType)), parameterType);
                    continue;
                }
                args[i] = ParamTypeUtil.parse(parameterValues[0], parameterType);
                continue;
            }
            if (jsonBodyStr == null) {
                if (!parameterType.isPrimitive()) continue;
                args[i] = ParamTypeUtil.setDefault(parameterType);
                continue;
            }
            if (jsonObject == null) continue;
            if (parameterType.isArray()) {
                JSONArray jsonArray = jsonObject.getJSONArray(params[i]);
                String[] stringArray2 = new String[jsonArray.size()];
                for (int j = 0; j < stringArray2.length; ++j) {
                    stringArray2[j] = String.valueOf(jsonArray.get(j));
                }
                args[i] = ParamTypeUtil.parse(stringArray2, parameterType);
                continue;
            }
            args[i] = ParamTypeUtil.parse(jsonObject.getString(params[i]), parameterType);
        }
        if (parameterTypes[parameterTypes.length - 1] == BindingResult.class) {
            args[parameterTypes.length - 1] = new BindingResult(errMsgs);
        } else if (errMsgs != null && errMsgs.size() > 0) {
            throw new TipException((String)errMsgs.get(0));
        }
        return args;
    }
}

