/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.restful.render;

import cn.jants.common.bean.Page;
import cn.jants.common.enums.ResponseCode;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

public class Json {
    private static final String STATE = "code";
    private static final String MSG = "message";
    private static final String RESULT = "data";
    private static final String TIMESPAN = "time";
    private static final String ERROR = "exception";
    private static final String INDEX = "index";
    private static final String SIZE = "size";
    private static final String TOTAL = "total";
    private static final String PAGES = "pages";

    public static <T> Map success(T data, Long startTime) {
        if (data == null) {
            return Json.fail(ResponseCode.DATA_NULL_ERROR);
        }
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        map.put(STATE, ResponseCode.SUCCESS.getCode());
        map.put(MSG, ResponseCode.SUCCESS.getMsg());
        if (startTime != null) {
            map.put(TIMESPAN, System.currentTimeMillis() - startTime + " msec");
        } else if (data.getClass() == Page.class) {
            Page page = (Page)data;
            map.put(RESULT, page.getData());
            map.put(INDEX, page.getIndex());
            map.put(SIZE, page.getSize());
            map.put(TOTAL, page.getTotal());
            map.put(PAGES, page.getPages());
        } else {
            map.put(RESULT, data);
        }
        return map;
    }

    public static <T> Map<String, T> success(T data) {
        return Json.success(data, null);
    }

    public static <T> Map<String, T> ui(T data) {
        if (data == null) {
            return Json.fail(ResponseCode.DATA_NULL_ERROR);
        }
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        map.put(STATE, ResponseCode.SUCCESS.getCode());
        map.put(MSG, ResponseCode.SUCCESS.getMsg());
        if (data.getClass() == Page.class) {
            Page page = (Page)data;
            map.put(RESULT, page.getData());
            map.put(TOTAL, page.getTotal());
        } else {
            map.put(RESULT, data);
        }
        return map;
    }

    public static Object exception(ResponseCode responseCode, String exception) {
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        map.put(STATE, responseCode.getCode());
        map.put(MSG, responseCode.getMsg());
        map.put(ERROR, exception);
        return JSON.toJSON(map);
    }

    public static Object exception(ResponseCode responseCode) {
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        map.put(STATE, responseCode.getCode());
        map.put(MSG, responseCode.getMsg());
        return JSON.toJSON(map);
    }

    public static Object exception(Integer code, String exception) {
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        map.put(STATE, code);
        map.put(MSG, exception);
        return JSON.toJSON(map);
    }

    public static Map fail(ResponseCode responseCode) {
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        map.put(STATE, responseCode.getCode());
        map.put(MSG, responseCode.getMsg());
        return map;
    }

    public static Map fail(int code, String msg) {
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        map.put(STATE, code);
        map.put(MSG, msg);
        return map;
    }

    public static Map fail(String msg) {
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        map.put(STATE, ResponseCode.REQUEST_ERROR.getCode());
        map.put(MSG, msg);
        return map;
    }

    public static void writeJson(Object data, HttpServletResponse response, boolean serializers) {
        response.setContentType("application/json;charset=" + response.getCharacterEncoding());
        try {
            PrintWriter w = response.getWriter();
            if (serializers) {
                w.print(JSON.toJSONString((Object)data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteNullListAsEmpty}));
            } else {
                w.print(JSON.toJSONString((Object)data));
            }
            w.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeJson(Object data, HttpServletResponse response) {
        Json.writeJson(data, response, false);
    }
}

