/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.plugin.tool;

import cn.jants.common.bean.Log;
import cn.jants.common.bean.Prop;
import cn.jants.common.utils.HttpUtil;
import cn.jants.common.utils.StrUtil;
import cn.jants.core.holder.ClientHolder;
import cn.jants.plugin.pay.wx.Sign;
import cn.jants.plugin.weixin.ApiResult;
import cn.jants.plugin.weixin.TokenCache;
import cn.jants.plugin.weixin.WxToken;
import java.util.TreeMap;

public class WxJsApiTool {
    private static TokenCache jsApiTicketCache = new TokenCache();

    public static String getJsApiTicketStr(String appId, String appSecret) {
        appId = Prop.getKeyStrValue(appId);
        appSecret = Prop.getKeyStrValue(appSecret);
        Long expires = jsApiTicketCache.getExpires();
        long currentTime = System.currentTimeMillis();
        if (expires == null || currentTime - expires > 7000000L) {
            String accessTokenStr = WxToken.getAccessTokenStr(appId, appSecret);
            String response = HttpUtil.sendGet(String.format("https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=%s&type=jsapi", accessTokenStr));
            ApiResult apiResult = new ApiResult(response);
            String ticket = apiResult.getStr("ticket");
            jsApiTicketCache.setTokenCache(ticket, currentTime);
            return ticket;
        }
        String ticket = jsApiTicketCache.getToken();
        Log.debug("\u53d6\u7f13\u5b58JsApiTicket > {}", ticket);
        return ticket;
    }

    public static ApiResult getJsApiSignature(String appId, String appSecret) {
        appId = Prop.getKeyStrValue(appId);
        appSecret = Prop.getKeyStrValue(appSecret);
        String jsApiTicketStr = WxJsApiTool.getJsApiTicketStr(appId, appSecret);
        Long timeStamp = System.currentTimeMillis() / 1000L;
        String nonceStr = StrUtil.randomUUID();
        String webUrl = ClientHolder.getWebUrl();
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        params.put("jsapi_ticket", jsApiTicketStr);
        params.put("noncestr", nonceStr);
        params.put("timestamp", timeStamp);
        params.put("url", webUrl);
        Log.debug("signature params > {}", params);
        ApiResult apiResult = new ApiResult();
        apiResult.put("appId", appId);
        apiResult.put("timestamp", timeStamp);
        apiResult.put("nonceStr", nonceStr);
        apiResult.put("signature", Sign.sha1(Sign.pj(params)));
        return apiResult;
    }
}

