/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.plugin.tool;

import cn.jants.common.bean.Log;
import cn.jants.common.bean.Prop;
import cn.jants.common.utils.GenUtil;
import cn.jants.common.utils.StrUtil;
import cn.jants.plugin.cache.RedisTpl;
import cn.jants.plugin.tool.ConcurrentToolMap;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.util.Pool;

public final class RedisTool
extends ConcurrentToolMap {
    public static RedisTpl getRedis(String host, String port, String password, String database) {
        host = Prop.getKeyStrValue(host);
        port = Prop.getKeyStrValue(port);
        password = Prop.getKeyStrValue(password);
        database = Prop.getKeyStrValue(database);
        String key = "redis_".concat(GenUtil.makeMd5Str(host, port, password, database));
        if (PLUGINS.containsKey(key)) {
            return (RedisTpl)PLUGINS.get(key);
        }
        Jedis jedis = new Jedis(host, Integer.valueOf(port).intValue());
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxTotal(500);
        config.setMaxIdle(60000);
        config.setMaxWaitMillis(10000L);
        config.setTestOnBorrow(true);
        jedis.setDataSource((Pool)new JedisPool((GenericObjectPoolConfig)config, host, Integer.valueOf(port).intValue()));
        if (StrUtil.notBlank(password)) {
            jedis.auth(password);
        }
        try {
            if (StrUtil.notBlank(database)) {
                jedis.select(Integer.valueOf(database).intValue());
            } else {
                jedis.select(0);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("error , Redis\u8fde\u63a5\u5931\u8d25... -> %s", e.getMessage()));
        }
        Log.debug("db > db{} , Redis\u8fde\u63a5\u6210\u529f... ", database);
        RedisTpl redisTpl = new RedisTpl(jedis);
        PLUGINS.put(key, redisTpl);
        return redisTpl;
    }

    public static RedisTpl getRedis(String host, String port, String password) {
        return RedisTool.getRedis(host, port, password, null);
    }

    public static RedisTpl getRedis() {
        String host = Prop.getStr("ants.redis.host");
        String port = Prop.getStr("ants.redis.port");
        String password = Prop.getStr("ants.redis.password");
        String database = Prop.getStr("ants.redis.database");
        if (StrUtil.notBlank(host, port)) {
            return RedisTool.getRedis(host, port, password, database);
        }
        throw new RuntimeException("\u6ca1\u6709\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u627e\u5230Redis\u9ed8\u8ba4\u914d\u7f6e");
    }
}

