/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.plugin.scheduler;

import cn.jants.common.annotation.service.Service;
import cn.jants.common.bean.Log;
import cn.jants.core.ext.Plugin;
import cn.jants.core.module.ServiceManager;
import cn.jants.core.utils.GenerateUtil;
import cn.jants.plugin.scheduler.FixedDelay;
import cn.jants.plugin.scheduler.SchedulerBean;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;

public class SchedulerPlugin
implements Plugin {
    private List<SchedulerBean> list;
    private ScheduledThreadPoolExecutor exec = new ScheduledThreadPoolExecutor(1);

    public SchedulerPlugin(List<SchedulerBean> list) {
        this.list = list;
    }

    @Override
    public boolean start() {
        for (SchedulerBean scheduler : this.list) {
            FixedDelay fixedDelay = scheduler.getFixedDelay();
            Class<?> cls = scheduler.getCls();
            Object object = null;
            try {
                object = cls.newInstance();
                if (!(object instanceof Runnable)) continue;
                if (cls.getDeclaredAnnotation(Service.class) != null) {
                    String serName = cls.getName();
                    String key = GenerateUtil.createServiceKey(serName);
                    object = ServiceManager.getService(key);
                }
                Runnable target = (Runnable)object;
                this.exec.scheduleWithFixedDelay(target, fixedDelay.initialDelay(), fixedDelay.delay(), fixedDelay.timeUnit());
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                break;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                break;
            }
        }
        return true;
    }

    @Override
    public boolean destroy() {
        this.exec.shutdown();
        Log.debug("ScheduledThreadPoolExecutor \u4efb\u52a1\u8c03\u5ea6\u5df2\u9500\u6bc1 ...", new Object[0]);
        return true;
    }
}

