/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.plugin.oss;

import cn.jants.common.bean.Log;
import cn.jants.plugin.oss.OssResult;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class AliOssTpl {
    private OSSClient client;
    private String bucketName;
    private String url;

    public AliOssTpl(OSSClient client, String url, String bucketName) {
        this.client = client;
        this.bucketName = bucketName;
        this.url = url;
    }

    public OSSClient getClient() {
        return this.client;
    }

    public OssResult uploadFile2OSS(File file, String diskName) {
        return this.uploadFile2OSS(file, null, diskName);
    }

    public OssResult uploadFile2OSS(File file, String rename, String diskName) {
        try {
            Long fileSize = file.length();
            String fileName = file.getName();
            FileInputStream is = new FileInputStream(file);
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength((long)((InputStream)is).available());
            metadata.setCacheControl("no-cache");
            metadata.setHeader("Pragma", (Object)"no-cache");
            metadata.setContentEncoding("utf-8");
            metadata.setContentType(this.getContentType(fileName));
            metadata.setContentDisposition("filename/filesize=" + fileName + "/" + fileSize + "Byte.");
            String urlStr = this.url.concat("/").concat(diskName).concat(rename);
            PutObjectResult putResult = this.client.putObject(this.bucketName, diskName + (rename == null ? fileName : rename), (InputStream)is, metadata);
            return new OssResult(true, "\u4e0a\u4f20\u6210\u529f > ".concat(file.getName().concat(" !")), urlStr, putResult.getETag());
        }
        catch (Exception e) {
            Log.error("\u4e0a\u4f20\u963f\u91cc\u4e91OSS\u670d\u52a1\u5668\u5f02\u5e38." + e.getMessage(), e);
            return new OssResult(false, "\u4e0a\u4f20\u5931\u8d25 > ".concat(file.getName().concat(" !")), null, null);
        }
    }

    public OssResult uploadUrl2OSS(String url, String fileName, String diskName) {
        try {
            URL reqUrl = new URL(url);
            HttpURLConnection httpURLConnection = (HttpURLConnection)reqUrl.openConnection();
            httpURLConnection.setConnectTimeout(3000);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestMethod("GET");
            int responseCode = httpURLConnection.getResponseCode();
            if (responseCode == 200) {
                InputStream inputStream = httpURLConnection.getInputStream();
                try {
                    int fileSize = httpURLConnection.getContentLength();
                    ObjectMetadata metadata = new ObjectMetadata();
                    metadata.setContentLength((long)fileSize);
                    metadata.setCacheControl("no-cache");
                    metadata.setHeader("Pragma", (Object)"no-cache");
                    metadata.setContentEncoding("utf-8");
                    metadata.setContentType(this.getContentType(fileName));
                    metadata.setContentDisposition("filename/filesize=" + fileName + "/" + fileSize + "Byte.");
                    PutObjectResult putResult = this.client.putObject(this.bucketName, diskName + fileName, inputStream, metadata);
                    String urlStr = url.concat("/").concat(diskName).concat(fileName);
                    return new OssResult(true, "\u4e0a\u4f20\u6210\u529f > ".concat(fileName.concat(" !")), urlStr, putResult.getETag());
                }
                catch (Exception e) {
                    Log.error("\u4e0a\u4f20\u963f\u91cc\u4e91OSS\u670d\u52a1\u5668\u5f02\u5e38." + e.getMessage(), e);
                    return new OssResult(false, "\u4e0a\u4f20\u5931\u8d25 > ".concat(fileName.concat(" !")), null, null);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public OssResult uploadStream2OSS(InputStream is, String fileName, String diskName) {
        try {
            Integer fileSize = is.available();
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength((long)is.available());
            metadata.setCacheControl("no-cache");
            metadata.setHeader("Pragma", (Object)"no-cache");
            metadata.setContentEncoding("utf-8");
            metadata.setContentType(this.getContentType(fileName));
            metadata.setContentDisposition("filename/filesize=" + fileName + "/" + fileSize + "Byte.");
            PutObjectResult putResult = this.client.putObject(this.bucketName, diskName + fileName, is, metadata);
            String urlStr = this.url.concat("/").concat(diskName).concat(fileName);
            return new OssResult(true, "\u4e0a\u4f20\u6210\u529f > ".concat(fileName.concat(" !")), urlStr, putResult.getETag());
        }
        catch (Exception e) {
            Log.error("\u4e0a\u4f20\u963f\u91cc\u4e91OSS\u670d\u52a1\u5668\u5f02\u5e38." + e.getMessage(), e);
            return new OssResult(false, "\u4e0a\u4f20\u5931\u8d25 > ".concat(fileName.concat(" !")), null, null);
        }
    }

    public OssResult delete(String objectName) {
        boolean exist = this.client.doesObjectExist(this.bucketName, objectName);
        if (exist) {
            this.client.deleteObject(this.bucketName == null ? this.bucketName : this.bucketName, objectName);
            return new OssResult(true, "\u6587\u4ef6\u5220\u9664\u6210\u529f > ".concat(objectName));
        }
        return new OssResult(false, "\u6587\u4ef6\u4e0d\u5b58\u5728, \u5220\u9664\u5931\u8d25!");
    }

    public String getContentType(String fileName) {
        Path path = Paths.get(fileName, new String[0]);
        String contentType = null;
        try {
            contentType = Files.probeContentType(path);
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.debug("File content type is : " + contentType, new Object[0]);
        }
        return contentType;
    }
}

