/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.plugin.orm;

import cn.jants.common.utils.StrCaseUtil;
import cn.jants.common.utils.StrUtil;
import cn.jants.plugin.orm.Column;
import cn.jants.plugin.orm.Cond;
import cn.jants.plugin.orm.Conditions;
import cn.jants.plugin.orm.Id;
import cn.jants.plugin.orm.SqlParams;
import cn.jants.plugin.orm.Table;
import cn.jants.plugin.orm.TableBean;
import cn.jants.plugin.orm.enums.Condition;
import cn.jants.restful.bind.utils.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TableMapper {
    private static final ConcurrentMap<Class, TableBean> TABLES = new ConcurrentHashMap<Class, TableBean>();

    public static TableBean findTableBean(Class<?> cls) {
        Field[] fields;
        if (TABLES.containsKey(cls)) {
            return (TableBean)TABLES.get(cls);
        }
        TableBean tableBean = new TableBean();
        Class<?> superclass = cls.getSuperclass();
        Table table = superclass.getDeclaredAnnotation(Table.class);
        if (table != null) {
            fields = superclass.getDeclaredFields();
        } else {
            table = cls.getDeclaredAnnotation(Table.class);
            fields = cls.getDeclaredFields();
        }
        String tableName = table.name();
        tableBean.setTable(tableName);
        ArrayList<String> list = new ArrayList<String>();
        for (Field field : fields) {
            Column column = field.getDeclaredAnnotation(Column.class);
            if (column == null) continue;
            String columnName = column.name();
            list.add(columnName);
            Id primaryKey = field.getDeclaredAnnotation(Id.class);
            if (primaryKey == null) continue;
            tableBean.setPrimaryKey(columnName);
        }
        tableBean.setFields(list);
        TABLES.put(cls, tableBean);
        return tableBean;
    }

    public static SqlParams createQuerySql(TableBean tableBean, Conditions conditions) {
        String orderByStr;
        SqlParams sqlParams = new SqlParams();
        StringBuffer sql = new StringBuffer("select");
        sql.append(conditions.getLabel());
        sql.append(" from ");
        sql.append(tableBean.getTable());
        List<String> relations = conditions.getRelations();
        if (relations.size() > 0) {
            for (String relation : relations) {
                sql.append(" ").append(relation);
            }
        }
        ArrayList params = new ArrayList();
        SqlParams condParams = TableMapper.makeConditionsSql(conditions, new StringBuffer(), sqlParams, params);
        sql.append(condParams.getSql());
        String groupByStr = conditions.getGroupBy();
        if (groupByStr != null) {
            sql.append(" group by ".concat(groupByStr));
        }
        if ((orderByStr = conditions.getOrderBy()) != null) {
            sql.append(orderByStr);
        }
        if (StrUtil.notBlank(conditions.getLimit())) {
            sql.append(conditions.getLimit());
        }
        sqlParams.setSql(sql.toString());
        sqlParams.setParams(condParams.getParams());
        return sqlParams;
    }

    public static SqlParams createDeleteSql(TableBean tableBean, Conditions conditions) {
        SqlParams sqlParams = new SqlParams();
        if (tableBean == null) {
            throw new RuntimeException("\u6ca1\u6709\u627e\u5230ORM\u6620\u5c04!");
        }
        StringBuffer sql = new StringBuffer("delete from ");
        sql.append(tableBean.getTable());
        ArrayList params = new ArrayList();
        return TableMapper.makeConditionsSql(conditions, sql, sqlParams, params);
    }

    public static SqlParams createUpdateSql(Object obj, Conditions conditions) {
        SqlParams sqlParams = new SqlParams();
        Class<?> cls = obj.getClass();
        TableBean tableBean = TableMapper.findTableBean(cls);
        if (tableBean == null) {
            throw new RuntimeException(cls + " \u6ca1\u6709\u627e\u5230ORM\u6620\u5c04!");
        }
        if (cls.getDeclaredAnnotation(Table.class) == null) {
            throw new RuntimeException(obj + " \u5f53\u524d\u5b9e\u4f53\u6ca1\u6709@Table\u6ce8\u89e3, \u4e0d\u662f\u5b9e\u4f53\u6620\u5c04\u7c7b!");
        }
        StringBuffer sql = new StringBuffer("update ");
        sql.append(tableBean.getTable());
        List<String> fields = tableBean.getFields();
        ArrayList<Object> params = new ArrayList<Object>();
        for (int i = 0; i < fields.size(); ++i) {
            if (i == 0) {
                sql.append(" set ");
            }
            String field = fields.get(i);
            Field declaredField = ReflectionUtils.findField(cls, StrCaseUtil.toCamelCase(field));
            ReflectionUtils.makeAccessible(declaredField);
            Object objValue = ReflectionUtils.getField(declaredField, obj);
            if (!StrUtil.notNull(objValue)) continue;
            if (declaredField.getDeclaredAnnotation(Id.class) == null) {
                sql.append(field).append("=?,");
                params.add(objValue);
                continue;
            }
            conditions.and(field, Condition.EQ, objValue);
        }
        sql.delete(sql.length() - 1, sql.length());
        return TableMapper.makeConditionsSql(conditions, sql, sqlParams, params);
    }

    public static SqlParams createInsertSql(Object obj) {
        SqlParams sqlParams = new SqlParams();
        Class<?> cls = obj.getClass();
        TableBean tableBean = TableMapper.findTableBean(cls);
        if (tableBean == null) {
            throw new RuntimeException(cls + " \u6ca1\u6709\u627e\u5230ORM\u6620\u5c04!");
        }
        StringBuffer sql = new StringBuffer("insert into ");
        sql.append(tableBean.getTable()).append("(");
        List<String> fields = tableBean.getFields();
        StringBuffer valBuff = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        for (int i = 0; i < fields.size(); ++i) {
            String field = fields.get(i);
            Field declaredField = ReflectionUtils.findField(cls, StrCaseUtil.toCamelCase(field));
            ReflectionUtils.makeAccessible(declaredField);
            Object objValue = ReflectionUtils.getField(declaredField, obj);
            if (!StrUtil.notNull(objValue)) continue;
            sql.append(field).append(",");
            valBuff.append("?").append(",");
            params.add(objValue);
        }
        sql.delete(sql.length() - 1, sql.length());
        sql.append(") values(");
        valBuff.delete(valBuff.length() - 1, valBuff.length());
        sql.append(valBuff.toString());
        sql.append(")");
        sqlParams.setSql(sql.toString());
        sqlParams.setParams(params.toArray());
        return sqlParams;
    }

    private static SqlParams makeConditionsSql(Conditions conditions, StringBuffer sql, SqlParams sqlParams, List params) {
        boolean isSelect = conditions.getRelations().size() > 0;
        List<Cond> conds = conditions.getConditions();
        if (conds.size() > 0) {
            sql.append(" where");
            for (int i = 0; i < conds.size(); ++i) {
                Cond cond = conds.get(i);
                Object value = cond.getValue();
                int inParamSize = 0;
                if (value.getClass().isArray()) {
                    Object[] objs;
                    for (Object objValue : objs = (Object[])value) {
                        params.add(objValue);
                        ++inParamSize;
                    }
                } else {
                    params.add(value);
                }
                if (i != 0) {
                    sql.append(cond.getSymbol().getValue());
                }
                String field = cond.getField();
                if (cond.getCond() == Condition.IN) {
                    sql.append(" ").append(String.format(cond.getCond().getValue(), StrCaseUtil.toUnderlineName(field)));
                    sql.append("(");
                    for (int j = 0; j < inParamSize; ++j) {
                        sql.append("?,");
                    }
                    sql.delete(sql.length() - 1, sql.length());
                    sql.append(")");
                    continue;
                }
                sql.append(" ").append(String.format(cond.getCond().getValue(), StrCaseUtil.toUnderlineName(field)));
            }
        }
        sqlParams.setSql(sql.toString());
        sqlParams.setParams(params.toArray());
        return sqlParams;
    }
}

