/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.plugin.mongo;

import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;

public class MongoDbTpl {
    private DB db;

    public DB getDB() {
        return this.db;
    }

    public MongoDbTpl(DB db) {
        this.db = db;
    }

    public List<DBObject> findList(DBObject conditions, String collectionName) {
        DBCollection table = this.db.getCollection(collectionName);
        DBCursor cursor = table.find(conditions);
        ArrayList<DBObject> result = new ArrayList<DBObject>(cursor.size());
        while (cursor.hasNext()) {
            result.add(cursor.next());
        }
        return result;
    }

    public DBObject findOne(DBObject conditions, String collectionName) {
        DBCollection table = this.db.getCollection(collectionName);
        return table.findOne(conditions);
    }

    public void remove(DBObject conditions, String collectionName) {
        DBCollection table = this.db.getCollection(collectionName);
        table.remove(conditions);
    }

    public void save(List<DBObject> dbObject, String collectionName) {
        DBCollection table = this.db.getCollection(collectionName);
        table.insert(dbObject);
    }

    public void save(DBObject dbObject, String collectionName) {
        DBCollection table = this.db.getCollection(collectionName);
        table.insert(new DBObject[]{dbObject});
    }

    public void update(DBObject conditions, DBObject dbObject, String collectionName) {
        DBCollection table = this.db.getCollection(collectionName);
        table.update(conditions, dbObject);
    }
}

