/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.plugin.jms;

import cn.jants.common.bean.Log;
import cn.jants.core.ext.Plugin;
import cn.jants.core.module.ServiceManager;
import cn.jants.plugin.jms.ActiveMqTpl;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;

public class ActiveMqPlugin
implements Plugin {
    private String brokenUrl;
    private String username;
    private String password;
    private Connection connection;

    public ActiveMqPlugin(String brokenUrl, String username, String password) {
        this.brokenUrl = brokenUrl;
        this.username = username;
        this.password = password;
    }

    @Override
    public boolean start() throws Exception {
        try {
            ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.username, this.password, this.brokenUrl);
            this.connection = connectionFactory.createConnection();
            this.connection.start();
            Session session = this.connection.createSession(Boolean.TRUE.booleanValue(), 0);
            Log.debug("ActiveMq Jms \u8fde\u63a5\u6210\u529f... ", new Object[0]);
            ActiveMqTpl activeMqTpl = new ActiveMqTpl(session);
            ServiceManager.setService("plugin_jms_ActiveMqTpl", activeMqTpl);
            return true;
        }
        catch (Exception e) {
            Log.error("ActiveMq Jms \u8fde\u63a5\u5931\u8d25, \u8bf7\u8ba4\u771f\u68c0\u67e5\u914d\u7f6e ... ", e.getMessage());
            throw new Exception(e);
        }
    }

    @Override
    public boolean destroy() {
        try {
            this.connection.close();
            return true;
        }
        catch (JMSException e) {
            e.printStackTrace();
            return false;
        }
    }
}

