/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.plugin.db;

import cn.jants.core.ext.Plugin;
import cn.jants.plugin.db.CommonProperty;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.beans.PropertyVetoException;
import java.sql.SQLException;
import javax.sql.DataSource;

public class C3p0Plugin
extends CommonProperty
implements Plugin {
    private ComboPooledDataSource dataSource = null;

    public C3p0Plugin(String url, String driverClassName, String username, String password) {
        super(url, driverClassName, username, password);
    }

    public C3p0Plugin(String name, String url, String driverClassName, String username, String password) {
        super(name, url, driverClassName, username, password);
    }

    @Override
    public boolean start() throws SQLException {
        try {
            this.dataSource = new ComboPooledDataSource();
            this.dataSource.setDriverClass(this.getDriverClassName());
            this.dataSource.setJdbcUrl(this.getUrl());
            this.dataSource.setUser(this.getUsername());
            this.dataSource.setPassword(this.getPassword());
            this.test("test c3p0 dataSource!", (DataSource)this.dataSource);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean destroy() {
        try {
            this.dataSource.getConnection().close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.dataSource = null;
        }
        return true;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public static DataSource getDataSource(String url, String driverClassName, String username, String password) {
        try {
            ComboPooledDataSource comboPooledDataSource = new ComboPooledDataSource();
            comboPooledDataSource.setDriverClass(driverClassName);
            comboPooledDataSource.setJdbcUrl(url);
            comboPooledDataSource.setUser(username);
            comboPooledDataSource.setPassword(password);
            return comboPooledDataSource;
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
            return null;
        }
    }
}

