/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.plugin.cache;

import cn.jants.core.utils.ParamTypeUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import redis.clients.jedis.Jedis;

public class RedisTpl {
    private Jedis jedis;

    public RedisTpl(Jedis jedis) {
        this.jedis = jedis;
    }

    public Jedis getJedis() {
        return this.jedis;
    }

    public boolean set(String key, Object value) {
        boolean result = false;
        try {
            if (ParamTypeUtil.isBaseDataType(value.getClass())) {
                this.jedis.set(key, String.valueOf(value));
            } else {
                this.jedis.set(key, JSON.toJSONString((Object)value));
            }
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean set(String key, Object value, int seconds) {
        boolean result = false;
        try {
            this.set(key, value);
            this.jedis.expire(key, seconds);
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void remove(String ... keys) {
        for (String key : keys) {
            if (!this.exists(key)) continue;
            this.jedis.del(key);
        }
    }

    public boolean exists(String key) {
        boolean exists = this.jedis.exists(key);
        return exists;
    }

    public String getStr(String key) {
        String result = this.jedis.get(key);
        return result;
    }

    public JSONObject get(String key) {
        String jsonStr = this.jedis.get(key);
        return JSON.parseObject((String)jsonStr);
    }

    public <T> T get(String key, Class<T> cls) {
        String jsonStr = this.jedis.get(key);
        return (T)JSON.parseObject((String)jsonStr, cls);
    }
}

