/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.plugin.cache;

import java.io.Serializable;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;

public class EhCacheTpl {
    private CacheManager cacheManager;
    public static final String DEFAULT_CACHE = "defaultCache";

    public EhCacheTpl(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void put(String cacheName, String key, Object value, Integer seconds) {
        if (cacheName == null) {
            cacheName = DEFAULT_CACHE;
        }
        Cache cache = this.cacheManager.getCache(cacheName);
        Element element = new Element((Object)key, value);
        if (seconds != null) {
            element.setTimeToIdle(seconds.intValue());
        }
        cache.put(element);
    }

    public void put(String cacheName, String key, Object value) {
        this.put(cacheName, key, value, null);
    }

    public void put(String key, Object value, Integer seconds) {
        this.put(null, key, value, seconds);
    }

    public void put(String key, Object value) {
        this.put(null, key, value, null);
    }

    public Object get(String cacheName, String key) {
        Cache cache = this.cacheManager.getCache(cacheName);
        Element element = cache.get((Serializable)((Object)key));
        return element == null ? null : element.getObjectValue();
    }

    public Object get(String key) {
        return this.get(DEFAULT_CACHE, key);
    }

    public void remove(String cacheName, String key) {
        Cache cache = this.cacheManager.getCache(cacheName);
        cache.remove((Serializable)((Object)key));
    }

    public void remove(String key) {
        this.remove(DEFAULT_CACHE, key);
    }

    public Cache getCache(String cacheName) {
        return this.cacheManager.getCache(cacheName);
    }

    public Cache getCache() {
        return this.getCache(DEFAULT_CACHE);
    }

    public List<String> getKeys(String cacheName) {
        Cache cache = this.cacheManager.getCache(cacheName);
        return cache.getKeys();
    }

    public List<String> getKeys() {
        return this.getKeys(DEFAULT_CACHE);
    }

    public void clear(String prefix) {
        this.cacheManager.clearAllStartingWith(prefix);
    }
}

