/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.core.proxy;

import cn.jants.common.bean.Log;
import cn.jants.common.utils.StrEncryptUtil;
import cn.jants.common.utils.StrUtil;
import cn.jants.core.module.ServiceManager;
import cn.jants.plugin.cache.CacheEvict;
import cn.jants.plugin.cache.CachePut;
import cn.jants.plugin.cache.Cacheable;
import cn.jants.plugin.cache.EhCacheTpl;
import cn.jants.restful.bind.LocalVariableTableParameterNameDiscoverer;
import cn.jants.restful.bind.utils.ReflectionUtils;
import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;

public class CacheManager {
    private static final LocalVariableTableParameterNameDiscoverer LVP = new LocalVariableTableParameterNameDiscoverer();
    private boolean isOpen = false;
    private boolean exist = false;
    private Object result;
    private Cache ehcache;
    private String key;
    private int seconds;
    private String keySymbol = "#";

    public CacheManager(Object target, Method method, Object[] args) {
        Cacheable cache = method.getDeclaredAnnotation(Cacheable.class);
        if (cache != null) {
            this.isOpen = true;
            this.key = StrUtil.notBlank(cache.key()) ? this.getVarKey(cache.key(), target, method, args) : this.encodeStr(target, method, args);
            EhCacheTpl ehCacheTpl = ServiceManager.getService(EhCacheTpl.class);
            if (ehCacheTpl == null) {
                throw new RuntimeException("\u83b7\u53d6\u5b9e\u4f8b EhCacheTpl \u5931\u8d25, \u68c0\u67e5Ehcache\u914d\u7f6e!");
            }
            this.ehcache = StrUtil.isBlank(cache.value()) ? ehCacheTpl.getCache() : ehCacheTpl.getCache(cache.value());
            Element element = this.ehcache.get((Serializable)((Object)this.key));
            if (element != null && !this.ehcache.isExpired(element)) {
                this.exist = true;
                Log.debug("ehcache cache key > {}", this.key);
                this.result = this.ehcache.get((Serializable)((Object)this.key)).getObjectValue();
            }
            this.seconds = cache.seconds();
            return;
        }
        CacheEvict cacheEvict = method.getDeclaredAnnotation(CacheEvict.class);
        if (cacheEvict != null) {
            EhCacheTpl ehCacheTpl = ServiceManager.getService(EhCacheTpl.class);
            if (ehCacheTpl == null) {
                throw new RuntimeException("\u83b7\u53d6\u5b9e\u4f8b EhCacheTpl \u5931\u8d25, \u68c0\u67e5Ehcache\u914d\u7f6e!");
            }
            this.ehcache = StrUtil.isBlank(cacheEvict.value()) ? ehCacheTpl.getCache() : ehCacheTpl.getCache(cacheEvict.value());
            this.key = cacheEvict.key();
            if (StrUtil.notBlank(new String[0])) {
                this.ehcache.remove((Serializable)((Object)this.key));
            } else {
                this.ehcache.removeAll();
            }
            return;
        }
        CachePut cachePut = method.getDeclaredAnnotation(CachePut.class);
        if (cachePut != null) {
            EhCacheTpl ehCacheTpl = ServiceManager.getService(EhCacheTpl.class);
            if (ehCacheTpl == null) {
                throw new RuntimeException("\u83b7\u53d6\u5b9e\u4f8b EhCacheTpl \u5931\u8d25, \u68c0\u67e5Ehcache\u914d\u7f6e!");
            }
            this.ehcache = StrUtil.isBlank(cachePut.value()) ? ehCacheTpl.getCache() : ehCacheTpl.getCache(cachePut.value());
            String string = this.key = StrUtil.notBlank(cachePut.key()) ? this.getVarKey(cachePut.key(), target, method, args) : this.encodeStr(target, method, args);
            if (StrUtil.notBlank(new String[0])) {
                this.ehcache.remove((Serializable)((Object)this.key));
            } else {
                this.ehcache.removeAll();
            }
            this.seconds = cachePut.seconds();
            return;
        }
    }

    public Object getResult() {
        return this.result;
    }

    public void setCache(Object value) {
        Element element = new Element((Object)this.key, value);
        element.setTimeToIdle(this.seconds);
        this.ehcache.put(element);
    }

    public boolean isOpened() {
        return this.isOpen;
    }

    public boolean existCache() {
        return this.exist;
    }

    private String encodeStr(Object target, Method method, Object ... params) {
        String classesName = target.getClass().getSimpleName();
        String key = "[".concat(classesName).concat(".").concat(method.getName()).concat("(").concat(StrEncryptUtil.md5(JSON.toJSONString((Object)params))).concat(")]");
        Log.debug("create cache key > {}", key);
        return key;
    }

    private String getVarKey(String key, Object target, Method method, Object ... params) {
        if (StrUtil.isBlank(key)) {
            return null;
        }
        if (key.indexOf(this.keySymbol) != -1) {
            int ksNum = key.indexOf(this.keySymbol);
            String prefix = "";
            if (ksNum > 0) {
                prefix = key.split(this.keySymbol)[0];
                key = key.substring(ksNum + 1, key.length());
            } else {
                key = key.substring(1, key.length());
            }
            int s = key.indexOf(".");
            List<String> parameterNames = Arrays.asList(LVP.getParameterNames(method));
            String genKey = "";
            if (s != -1 && s != 0 && s != key.length() - 1) {
                String[] ps = key.split("\\.");
                int i = parameterNames.indexOf(ps[0]);
                if (i == -1) {
                    return null;
                }
                Object op = params[i];
                Class<?> cls = op.getClass();
                try {
                    Field field = cls.getDeclaredField(ps[1]);
                    ReflectionUtils.makeAccessible(field);
                    genKey = String.valueOf(ReflectionUtils.getField(field, op));
                }
                catch (NoSuchFieldException e) {
                    throw new IllegalArgumentException(String.format("%s \u6ca1\u627e\u5230\u9700\u8981\u7ed1\u5b9a\u7684\u5b9e\u4f53\u5b57\u6bb5 -> %s", cls.getSimpleName(), ps[1]));
                }
            } else {
                int i = parameterNames.indexOf(key);
                if (i == -1) {
                    return null;
                }
                genKey = String.valueOf(params[i]);
            }
            String simpleName = target.getClass().getSimpleName();
            return prefix.concat("_").concat(simpleName).concat("(").concat(genKey).concat(")");
        }
        return key;
    }
}

