/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.core.handler;

import cn.jants.common.annotation.action.NoUserToken;
import cn.jants.common.exception.TipException;
import cn.jants.common.utils.StrUtil;
import cn.jants.common.utils.TokenUtil;
import cn.jants.core.ext.Handler;
import cn.jants.core.module.RequestMappingManager;
import cn.jants.restful.request.MappingMatch;
import cn.jants.restful.request.RequestMappingBean;
import java.lang.reflect.Method;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.annotation.AnnotationUtils;

public class UserTokenHandler
implements Handler {
    private String userTokenName = "Api-User-Token";
    private final List<RequestMappingBean> requestMappingManager = RequestMappingManager.getRequestMappingManager();

    @Override
    public boolean preHandler(String target, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RequestMappingBean bean = MappingMatch.match(this.requestMappingManager, target);
        if (bean == null) {
            return true;
        }
        Method method = bean.getMethod();
        NoUserToken noUserToken = (NoUserToken)AnnotationUtils.findAnnotation((Method)method, NoUserToken.class);
        if (noUserToken == null) {
            this.checkUserToken(request);
        }
        return true;
    }

    private void checkUserToken(HttpServletRequest request) {
        String userTokenStr = request.getHeader(this.userTokenName);
        if (StrUtil.isBlank(userTokenStr)) {
            throw new TipException(String.format("\u7f3a\u5c11 %s \u53c2\u6570!", this.userTokenName));
        }
        TokenUtil.checkValidity(userTokenStr);
    }
}

