/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.core.handler;

import cn.jants.common.bean.Log;
import cn.jants.common.enums.ResponseCode;
import cn.jants.common.utils.StrUtil;
import cn.jants.core.ext.Handler;
import cn.jants.restful.render.Json;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LimitRefreshHandler
implements Handler {
    protected ConcurrentMap<String, ClientRequest> tokens = new ConcurrentHashMap<String, ClientRequest>();
    private String[] apis = null;
    private long time = 1000L;
    private long clearTime = 0x6DDD00L;
    private long count = 50L;
    private ScheduledThreadPoolExecutor exec = new ScheduledThreadPoolExecutor(1);

    public LimitRefreshHandler(String ... apis) {
        this.init(0L, 0L, 0L, apis);
    }

    public LimitRefreshHandler(long time, String ... apis) {
        this.init(0L, time, 0L, apis);
    }

    public LimitRefreshHandler(long clearTime, long time, String ... apis) {
        this.init(clearTime, time, 0L, apis);
    }

    public LimitRefreshHandler(long clearTime, long time, long count, String ... apis) {
        this.init(clearTime, time, count, apis);
    }

    private void init(long cTime, long time, long count, String ... apis) {
        try {
            this.apis = apis;
            if (time != 0L) {
                this.time = time;
            }
            if (count != 0L) {
                this.count = count;
            }
            if (cTime != 0L) {
                this.clearTime = cTime;
            }
            this.exec.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    Log.debug("limit refresh map is clear!", new Object[0]);
                }
            }, 0L, this.clearTime, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new RuntimeException("\u9632\u6b62\u5feb\u901f\u5237\u65b0\u914d\u6709\u8bef!" + e.getMessage());
        }
    }

    @Override
    public boolean preHandler(String target, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.apis != null) {
            String sessionId = request.getSession().getId();
            ClientRequest client = (ClientRequest)this.tokens.get(sessionId);
            if (client != null && !client.getCheck().booleanValue()) {
                this.writeBlackList(response);
                return false;
            }
            for (String api : this.apis) {
                if (!target.startsWith(api)) continue;
                if (this.tokens.containsKey(sessionId)) {
                    if (client.getUrl().equals(target)) {
                        long lastTime = client.getLastTime();
                        long currentTime = System.currentTimeMillis() - lastTime;
                        if (client.getCount() > this.count) {
                            client.setCheck(false);
                            this.tokens.put(sessionId, client);
                            this.writeBlackList(response);
                            return false;
                        }
                        if (currentTime > this.time) {
                            client.setLastTime(System.currentTimeMillis());
                            this.tokens.put(sessionId, client);
                            return true;
                        }
                        client.setLastTime(System.currentTimeMillis());
                        client.setCount(client.getCount() + 1L);
                        this.tokens.put(sessionId, client);
                        String queryStr = request.getQueryString();
                        if (StrUtil.notBlank(queryStr) && queryStr.indexOf("_refresh") != -1) {
                            return true;
                        }
                        try {
                            response.setContentType("application/json;charset=utf-8");
                            PrintWriter w = response.getWriter();
                            w.print(Json.exception(ResponseCode.REFRESH_INFO));
                            w.close();
                            return false;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            break;
                        }
                    }
                    client.setCheck(client.getCheck());
                    client.setLastTime(System.currentTimeMillis());
                    client.setUrl(target);
                    client.setCount(0L);
                    this.tokens.put(sessionId, client);
                    return true;
                }
                this.tokens.put(sessionId, new ClientRequest(request.getRemoteAddr(), target, System.currentTimeMillis(), 0L, true));
                return true;
            }
            return true;
        }
        return true;
    }

    private void writeBlackList(HttpServletResponse response) throws IOException {
        response.setContentType("application/json;charset=utf-8");
        PrintWriter w = response.getWriter();
        w.print("\u5df2\u7ecf\u88ab\u62c9\u9ed1\u5230\u4e86\u9ed1\u540d\u5355!");
        w.close();
    }

    private class ClientRequest {
        private String ip;
        private String url;
        private Long lastTime;
        private Long count;
        private Boolean isCheck;

        public ClientRequest(String ip, String url, Long lastTime, Long count, Boolean isCheck) {
            this.ip = ip;
            this.url = url;
            this.lastTime = lastTime;
            this.count = count;
            this.isCheck = isCheck;
        }

        public String getIp() {
            return this.ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public Long getLastTime() {
            return this.lastTime;
        }

        public void setLastTime(Long lastTime) {
            this.lastTime = lastTime;
        }

        public Long getCount() {
            return this.count;
        }

        public void setCount(Long count) {
            this.count = count;
        }

        public Boolean getCheck() {
            return this.isCheck;
        }

        public void setCheck(Boolean check) {
            this.isCheck = check;
        }
    }
}

