/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.common.utils;

import cn.jants.common.enums.Regex;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexUtil {
    public static synchronized boolean strIsNull(String str) {
        return null == str || str.trim().length() <= 0;
    }

    public static boolean strNotNull(String str) {
        return !RegexUtil.strIsNull(str);
    }

    public static String nullToStr(String str) {
        return RegexUtil.strIsNull(str) ? "" : str;
    }

    public static String nullToStr(String str, String defaultVal) {
        return RegexUtil.strIsNull(str) ? defaultVal : str;
    }

    public static boolean isEmail(String str) {
        return RegexUtil.Regular(str, Regex.EMAIL.getRegex());
    }

    public static boolean isPhone(String str) {
        return RegexUtil.Regular(str, Regex.PHONE.getRegex());
    }

    public static boolean isMobile(String str) {
        return RegexUtil.Regular(str, Regex.MOBILE.getRegex());
    }

    public static boolean isUrl(String str) {
        return RegexUtil.Regular(str, Regex.URL.getRegex());
    }

    public static boolean isNumber(String str) {
        return RegexUtil.Regular(str, Regex.DOUBLE.getRegex());
    }

    public static boolean isInteger(String str) {
        return RegexUtil.Regular(str, Regex.INTEGER.getRegex());
    }

    public static boolean isINTEGER_NEGATIVE(String str) {
        return RegexUtil.Regular(str, Regex.INTEGER_NEGATIVE.getRegex());
    }

    public static boolean isINTEGER_POSITIVE(String str) {
        return RegexUtil.Regular(str, Regex.INTEGER_POSITIVE.getRegex());
    }

    public static boolean isDouble(String str) {
        return RegexUtil.Regular(str, Regex.DOUBLE.getRegex());
    }

    public static boolean isDOUBLE_NEGATIVE(String str) {
        return RegexUtil.Regular(str, Regex.DOUBLE_NEGATIVE.getRegex());
    }

    public static boolean isDOUBLE_POSITIVE(String str) {
        return RegexUtil.Regular(str, Regex.DOUBLE_POSITIVE.getRegex());
    }

    public static boolean isDate(String str) {
        return RegexUtil.Regular(str, Regex.DATE_ALL.getRegex());
    }

    public static boolean isDate1(String str) {
        return RegexUtil.Regular(str, Regex.DATE_FORMAT1.getRegex());
    }

    public static boolean isAge(String str) {
        return RegexUtil.Regular(str, Regex.AGE.getRegex());
    }

    public static boolean isLengOut(String str, int leng) {
        return RegexUtil.strIsNull(str) ? false : str.trim().length() > leng;
    }

    public static boolean isIdCard(String str) {
        if (RegexUtil.strIsNull(str)) {
            return false;
        }
        if (str.trim().length() == 15 || str.trim().length() == 18) {
            return RegexUtil.Regular(str, Regex.IDCARD.getRegex());
        }
        return false;
    }

    public static boolean isCode(String str) {
        return RegexUtil.Regular(str, Regex.CODE.getRegex());
    }

    public static boolean isEnglish(String str) {
        return RegexUtil.Regular(str, Regex.STR_ENG.getRegex());
    }

    public static boolean isENG_NUM(String str) {
        return RegexUtil.Regular(str, Regex.STR_ENG_NUM.getRegex());
    }

    public static boolean isENG_NUM_(String str) {
        return RegexUtil.Regular(str, Regex.STR_ENG_NUM_.getRegex());
    }

    public static String filterStr(String str) {
        Pattern p = Pattern.compile(Regex.STR_SPECIAL.getRegex());
        Matcher m = p.matcher(str);
        return m.replaceAll("").trim();
    }

    public static boolean isJigouCode(String str) {
        return RegexUtil.Regular(str, Regex.JIGOU_CODE.getRegex());
    }

    public static boolean isSTR_NUM(String str) {
        return RegexUtil.Regular(str, Regex.STR_NUM.getRegex());
    }

    private static boolean Regular(String str, String pattern) {
        if (null == str || str.trim().length() <= 0) {
            return false;
        }
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(str);
        return m.matches();
    }
}

