/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.common.enums;

import cn.jants.common.annotation.service.Source;
import cn.jants.core.module.PluginManager;
import cn.jants.plugin.db.C3p0Plugin;
import cn.jants.plugin.db.Db;
import cn.jants.plugin.db.DbPlugin;
import cn.jants.plugin.db.DbcpPlugin;
import cn.jants.plugin.db.DruidPlugin;
import cn.jants.plugin.db.HikariCpPlugin;
import javax.sql.DataSource;

public enum DataSourceType {
    NONE,
    C3P0,
    DBCP,
    HIKARICP,
    DRUID;


    public static DataSource getDataSource(Source source) {
        DataSource dataSource = null;
        if (source.type() == HIKARICP) {
            HikariCpPlugin classObject;
            HikariCpPlugin hikariCpPlugin = classObject = "".equals(source.value()) ? PluginManager.findFirstSourcePluginObject(HikariCpPlugin.class) : PluginManager.findSourcePluginObject(HikariCpPlugin.class, source.value());
            if (classObject == null) {
                HikariCpPlugin sourcePluginObject = PluginManager.findRandomSourcePluginObject(HikariCpPlugin.class);
                if (sourcePluginObject != null) {
                    dataSource = sourcePluginObject.getDataSource();
                }
            } else {
                dataSource = PluginManager.findPluginObject(HikariCpPlugin.class).getDataSource();
            }
        } else if (source.type() == C3P0) {
            C3p0Plugin classObject;
            C3p0Plugin c3p0Plugin = classObject = "".equals(source.value()) ? PluginManager.findFirstSourcePluginObject(C3p0Plugin.class) : PluginManager.findSourcePluginObject(C3p0Plugin.class, source.value());
            if (classObject == null) {
                C3p0Plugin sourcePluginObject = PluginManager.findRandomSourcePluginObject(C3p0Plugin.class);
                if (sourcePluginObject != null) {
                    dataSource = sourcePluginObject.getDataSource();
                }
            } else {
                dataSource = classObject.getDataSource();
            }
        } else if (source.type() == DBCP) {
            DbcpPlugin classObject;
            DbcpPlugin dbcpPlugin = classObject = "".equals(source.value()) ? PluginManager.findFirstSourcePluginObject(DbcpPlugin.class) : PluginManager.findSourcePluginObject(DbcpPlugin.class, source.value());
            if (classObject == null) {
                DbcpPlugin sourcePluginObject = PluginManager.findRandomSourcePluginObject(DbcpPlugin.class);
                if (sourcePluginObject != null) {
                    dataSource = sourcePluginObject.getDataSource();
                }
            } else {
                dataSource = classObject.getDataSource();
            }
        } else if (source.type() == DRUID) {
            DruidPlugin classObject;
            DruidPlugin druidPlugin = classObject = "".equals(source.value()) ? PluginManager.findFirstSourcePluginObject(DruidPlugin.class) : PluginManager.findSourcePluginObject(DruidPlugin.class, source.value());
            if (classObject == null) {
                DruidPlugin sourcePluginObject = PluginManager.findRandomSourcePluginObject(DruidPlugin.class);
                if (sourcePluginObject != null) {
                    dataSource = sourcePluginObject.getDataSource();
                }
            } else {
                dataSource = classObject.getDataSource();
            }
        }
        return dataSource;
    }

    public static Db getNativeDb(String name) {
        DbPlugin dbPlugin;
        DbPlugin dbPlugin2 = dbPlugin = "".equals(name) ? PluginManager.findFirstSourcePluginObject(DbPlugin.class) : PluginManager.findSourcePluginObject(DbPlugin.class, name);
        if (dbPlugin == null) {
            throw new IllegalArgumentException("\u6ca1\u6709\u627e\u5230 > " + name + " \u6570\u636e\u6e90\u540d\u79f0!");
        }
        return dbPlugin.getDb();
    }
}

