/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.restful.render;

import cn.jants.common.annotation.boot.ViewConfiguration;
import cn.jants.common.enums.ViewType;
import cn.jants.common.utils.StrUtil;
import cn.jants.core.context.AppConstant;
import cn.jants.core.module.ServiceManager;
import cn.jants.plugin.template.BeetlTpl;
import cn.jants.plugin.template.FreeMarkerTpl;
import cn.jants.plugin.template.VelocityTpl;
import cn.jants.restful.render.ModelAndView;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class View {
    private static void render(Object viewName, ModelAndView modelAndView, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ViewConfiguration tplConfig = AppConstant.TPL_CONFIG;
        if (tplConfig == null) {
            throw new RuntimeException("\u9519\u8bef, \u6ca1\u6709\u914d\u7f6e\u4efb\u4f55\u6a21\u677f\u5f15\u64ce!");
        }
        String view = StrUtil.setFirstInitial(String.valueOf(viewName), Character.valueOf('/'));
        response.setContentType("text/html");
        if (tplConfig.viewType() == ViewType.JSP) {
            RequestDispatcher requestDispatcher = request.getRequestDispatcher(view);
            requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
        } else if (tplConfig.viewType() == ViewType.FREEMARKER) {
            FreeMarkerTpl freeMarkerTpl = (FreeMarkerTpl)ServiceManager.getService("plugin_template_FreeMarkerTpl");
            if (viewName != null) {
                freeMarkerTpl.render(String.valueOf(viewName), request, response);
            } else if (modelAndView != null) {
                freeMarkerTpl.render(modelAndView, request, response);
            }
        } else if (tplConfig.viewType() == ViewType.BEETL) {
            BeetlTpl beetlTpl = (BeetlTpl)ServiceManager.getService("plugin_template_BeetlTpl");
            if (viewName != null) {
                beetlTpl.render(String.valueOf(viewName), request, response);
            } else if (modelAndView != null) {
                beetlTpl.render(modelAndView, request, response);
            }
        } else if (tplConfig.viewType() == ViewType.VELOCITY) {
            VelocityTpl velocityTpl = (VelocityTpl)ServiceManager.getService("plugin_template_VelocityTpl");
            if (viewName != null) {
                velocityTpl.render(String.valueOf(viewName), request, response);
            } else if (modelAndView != null) {
                velocityTpl.render(modelAndView, request, response);
            }
        }
    }

    public static void render(Object viewName, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        View.render(viewName, null, request, response);
    }

    public static void render(ModelAndView modelAndView, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        View.render(null, modelAndView, request, response);
    }
}

