/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.plugin.tool;

import cn.jants.common.bean.Log;
import cn.jants.common.bean.Prop;
import cn.jants.common.utils.StrUtil;
import cn.jants.core.holder.ClientHolder;
import cn.jants.plugin.pay.ali.AliNotifyResult;
import cn.jants.plugin.pay.ali.AliPayApiResult;
import com.alibaba.fastjson.JSON;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.AlipayResponse;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.domain.AlipayFundTransToaccountTransferModel;
import com.alipay.api.domain.AlipayTradeAppPayModel;
import com.alipay.api.domain.AlipayTradePagePayModel;
import com.alipay.api.domain.AlipayTradePrecreateModel;
import com.alipay.api.domain.AlipayTradeRefundModel;
import com.alipay.api.request.AlipayFundTransToaccountTransferRequest;
import com.alipay.api.request.AlipayTradeAppPayRequest;
import com.alipay.api.request.AlipayTradePagePayRequest;
import com.alipay.api.request.AlipayTradePrecreateRequest;
import com.alipay.api.request.AlipayTradeRefundRequest;
import com.alipay.api.request.AlipayTradeWapPayRequest;
import com.alipay.api.response.AlipayFundTransToaccountTransferResponse;
import com.alipay.api.response.AlipayTradePrecreateResponse;
import com.alipay.api.response.AlipayTradeRefundResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AliPayTool {
    private String signType = "RSA2";
    private String url = "https://openapi.alipay.com/gateway.do";
    private String notifyUrl;
    private String returnUrl;
    private String publicKey;
    private AlipayClient client;
    private static final ConcurrentMap<String, AliPayTool> ALI_CLIENT_MAP = new ConcurrentHashMap<String, AliPayTool>();

    private AliPayTool(String appId, String privateKey, String notifyUrl, String returnUrl, String publicKey) {
        this.client = new DefaultAlipayClient(this.url, appId, privateKey, "json", "UTF-8", publicKey, this.signType);
        this.notifyUrl = notifyUrl;
        this.returnUrl = returnUrl;
    }

    public static AliPayTool init(String appId, String privateKey, String notifyUrl, String returnUrl, String publicKey) {
        appId = Prop.getKeyStrValue(appId);
        privateKey = Prop.getKeyStrValue(privateKey);
        notifyUrl = Prop.getKeyStrValue(notifyUrl);
        if (StrUtil.notBlank(returnUrl)) {
            returnUrl = Prop.getKeyStrValue(returnUrl);
        }
        publicKey = Prop.getKeyStrValue(publicKey);
        if (ALI_CLIENT_MAP.containsKey(appId)) {
            return (AliPayTool)ALI_CLIENT_MAP.get(appId);
        }
        AliPayTool aliPayTool = new AliPayTool(appId, privateKey, notifyUrl, returnUrl, publicKey);
        ALI_CLIENT_MAP.put(appId, aliPayTool);
        return aliPayTool;
    }

    public static AliPayTool init(String appId, String privateKey, String notifyUrl, String publicKey) {
        return AliPayTool.init(appId, privateKey, notifyUrl, null, publicKey);
    }

    public void printWapPay(AlipayTradePagePayModel model) {
        AlipayTradeWapPayRequest aliPayRequest = new AlipayTradeWapPayRequest();
        model.setProductCode("QUICK_MSECURITY_PAY");
        aliPayRequest.setBizModel((AlipayObject)model);
        aliPayRequest.setNotifyUrl(this.notifyUrl);
        aliPayRequest.setReturnUrl(this.returnUrl);
        try {
            String body = this.client.pageExecute((AlipayRequest)aliPayRequest).getBody();
            this.printPayPage(body);
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
            Log.error("\u652f\u4ed8\u5b9d\u751f\u6210WAP\u652f\u4ed8\u8868\u5355\u5b57\u7b26\u4e32\u5931\u8d25 > {} !", e.getErrMsg());
        }
    }

    public void printPcPay(AlipayTradePagePayModel model) {
        AlipayTradePagePayRequest aliPayRequest = new AlipayTradePagePayRequest();
        model.setProductCode("FAST_INSTANT_TRADE_PAY");
        aliPayRequest.setBizModel((AlipayObject)model);
        aliPayRequest.setNotifyUrl(this.notifyUrl);
        aliPayRequest.setReturnUrl(this.returnUrl);
        try {
            String body = this.client.pageExecute((AlipayRequest)aliPayRequest).getBody();
            this.printPayPage(body);
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
            Log.error("\u652f\u4ed8\u5b9d\u751f\u6210PC\u652f\u4ed8\u8868\u5355\u5b57\u7b26\u4e32\u5931\u8d25 > {} !", e.getErrMsg());
        }
    }

    public AliPayApiResult getAppPaySign(AlipayTradeAppPayModel model) {
        AlipayTradeAppPayRequest appRequest = new AlipayTradeAppPayRequest();
        model.setProductCode("QUICK_MSECURITY_PAY");
        appRequest.setBizModel((AlipayObject)model);
        appRequest.setNotifyUrl(this.notifyUrl);
        AlipayResponse response = null;
        try {
            response = this.client.sdkExecute((AlipayRequest)appRequest);
            String data = response.getBody();
            return new AliPayApiResult(data);
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
            return new AliPayApiResult(e.getErrCode(), e.getErrMsg());
        }
    }

    public AliPayApiResult sendRefund(AlipayTradeRefundModel model) {
        AlipayTradeRefundRequest refundRequest = new AlipayTradeRefundRequest();
        refundRequest.setBizModel((AlipayObject)model);
        try {
            AlipayTradeRefundResponse response = (AlipayTradeRefundResponse)this.client.execute((AlipayRequest)refundRequest);
            if (response.isSuccess()) {
                return new AliPayApiResult(response.getParams());
            }
            return new AliPayApiResult(response.getSubCode(), response.getSubMsg());
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
            return new AliPayApiResult(e.getErrCode(), e.getErrMsg());
        }
    }

    public AliPayApiResult createCodeUrl(AlipayTradePrecreateModel model) {
        AlipayTradePrecreateRequest createRequest = new AlipayTradePrecreateRequest();
        createRequest.setBizModel((AlipayObject)model);
        try {
            AlipayTradePrecreateResponse response = (AlipayTradePrecreateResponse)this.client.execute((AlipayRequest)createRequest);
            if (response.isSuccess()) {
                return new AliPayApiResult(response.getParams());
            }
            return new AliPayApiResult(response.getSubCode(), response.getSubMsg());
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
            return new AliPayApiResult(e.getErrCode(), e.getErrMsg());
        }
    }

    public AliPayApiResult sendTransfer(AlipayFundTransToaccountTransferModel model) {
        AlipayFundTransToaccountTransferRequest transferRequest = new AlipayFundTransToaccountTransferRequest();
        transferRequest.setBizContent(JSON.toJSONString((Object)model));
        try {
            AlipayFundTransToaccountTransferResponse response = (AlipayFundTransToaccountTransferResponse)this.client.execute((AlipayRequest)transferRequest);
            if (response.isSuccess()) {
                HashMap<String, String> jsonMap = new HashMap<String, String>();
                jsonMap.put("orderId", response.getOrderId());
                jsonMap.put("outBizNo", response.getOutBizNo());
                return new AliPayApiResult(JSON.toJSONString(jsonMap));
            }
            return new AliPayApiResult(response.getSubCode(), response.getSubMsg());
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
            return new AliPayApiResult(e.getErrCode(), e.getErrMsg());
        }
    }

    public AliNotifyResult getNotify() {
        HttpServletRequest request = ClientHolder.getRequest();
        String code = request.getParameter("code");
        AliNotifyResult notifyResult = null;
        notifyResult = "10000".equals(code) ? new AliNotifyResult(request) : new AliNotifyResult(code, request.getParameter("msg"));
        return notifyResult;
    }

    private void printPayPage(String body) {
        try {
            HttpServletResponse response = ClientHolder.getResponse();
            response.setContentType("text/html;charset=UTF-8");
            response.getWriter().write(body);
            response.getWriter().flush();
            response.getWriter().close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

